/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTableModel;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextAreaPanel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PropertyFormTable
extends SymbolTable
implements Disposable {
    private PropertyFormTableModel tableModel;

    public PropertyFormTable(PropertyFormTableModel tableModel, OWLNamedClass namedClass, RDFProperty property) {
        super(tableModel, namedClass.getOWLModel(), true, new OWLSymbolPanel(namedClass.getOWLModel(), true, true));
        this.tableModel = tableModel;
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel model, SymbolErrorDisplay errorDisplay) {
        return new ClassDescriptionEditorComponent(model, errorDisplay, true);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    protected String editMultiLine(RDFResource input) {
        if (input instanceof RDFSClass) {
            return OWLTextAreaPanel.showEditDialog((Component)((Object)this), this.getOWLModel(), (RDFSClass)input);
        }
        return null;
    }

    protected Collection getNavigationMenuItems(RDFResource resource) {
        if (resource instanceof RDFSClass) {
            HashSet set = new HashSet();
            ((RDFSClass)resource).getNestedNamedClasses(set);
            return set;
        }
        return Collections.EMPTY_LIST;
    }

    public PropertyFormTableModel getTableModel() {
        return this.tableModel;
    }

    protected String getToolTipText(RDFResource resource) {
        String str;
        if (resource instanceof RDFSClass && (str = OWLUI.getOWLToolTipText((RDFSClass)resource)) != null && str.length() > 0) {
            return str;
        }
        return null;
    }

    public boolean isClosed() {
        if (this.tableModel.getRowCount() > 0) {
            OWLExistentialRestriction restriction = this.tableModel.getRestriction(0);
            return ClosureAxiomFactory.getClosureAxiom(this.tableModel.getNamedClass(), restriction) != null;
        }
        return false;
    }

    protected void navigateTo(RDFResource instance) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (tab != null && instance instanceof RDFSNamedClass) {
            tab.setSelectedCls((RDFSNamedClass)instance);
        }
    }

    public void setClosed(boolean closed) {
    }
}

