/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.compactparser.TokenMgrError;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class OWLSymbolPanel
extends SymbolPanel {
    private Action allValuesFromAction;
    private Action cardinalityAction;
    private Action complementOfAction;
    private Action enumerationAction;
    private ResourceSelectionAction rdfDatatypeAction;
    private Action falseAction;
    private Action hasValueAction;
    private Action intersectionOfAction;
    private Action maxCardinalityAction;
    private Action minCardinalityAction;
    private Action roundBracketsAction;
    private Action someValuesFromAction;
    private Action trueAction;
    private Action unionOfAction;

    public OWLSymbolPanel(OWLModel owlModel, boolean closable) {
        this(owlModel, closable, false);
    }

    public OWLSymbolPanel(OWLModel owlModel, boolean closable, boolean draggable) {
        super(owlModel, closable, draggable);
    }

    public void enableActions(Slot slot, Cls restrictionsMetaCls) {
        boolean clses = false;
        boolean instances = false;
        boolean booleans = false;
        boolean datatypes = false;
        if (restrictionsMetaCls != null && slot != null) {
            String metaClsName = restrictionsMetaCls.getName();
            if (ProfilesManager.isFeatureSupported(this.getOWLModel(), OWLProfiles.Qualified_Cardinality_Restrictions)) {
                metaClsName = "owl:AllValuesFromRestriction";
            }
            if ("owl:AllValuesFromRestriction".equals(metaClsName) || "owl:SomeValuesFromRestriction".equals(metaClsName)) {
                if (!(slot instanceof OWLDatatypeProperty)) {
                    clses = true;
                    instances = true;
                    booleans = true;
                }
                datatypes = true;
            } else if ("owl:HasValueRestriction".equals(metaClsName)) {
                if (slot instanceof OWLDatatypeProperty) {
                    booleans = true;
                } else {
                    boolean full;
                    clses = full = OWLUtil.hasOWLFullProfile(this.getOWLModel());
                    booleans = full;
                    datatypes = full;
                    instances = true;
                }
            }
        }
        this.enableActions(clses, instances, datatypes, booleans);
    }

    public void enableActions(boolean clses, boolean instances) {
        super.enableActions(clses, instances);
        this.enableActions(clses, instances, true, true);
    }

    public void enableActions(boolean clses, boolean instances, boolean datatypes, boolean booleans) {
        super.enableActions(clses, instances);
        OWLModel owlModel = this.getOWLModel();
        this.allValuesFromAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.AllValuesFrom_Restrictions));
        this.cardinalityAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MaxCardinality_Restrictions) && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MinCardinality_Restrictions));
        this.complementOfAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Complement_Classes));
        this.rdfDatatypeAction.setEnabled(datatypes);
        this.hasValueAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.HasValue_Restrictions));
        this.intersectionOfAction.setEnabled(clses);
        this.maxCardinalityAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MaxCardinality_Restrictions));
        this.minCardinalityAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.MinCardinality_Restrictions));
        this.someValuesFromAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.SomeValuesFrom_Restrictions));
        this.unionOfAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Union_Classes));
        this.roundBracketsAction.setEnabled(clses);
        this.enumerationAction.setEnabled(clses && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Enumerated_Classes));
        this.falseAction.setEnabled(booleans);
        this.trueAction.setEnabled(booleans);
    }

    public String getDisplayErrorMessage(Throwable ex) {
        String message = null;
        if (ex instanceof OWLClassParseException) {
            OWLClassParseException pex = (OWLClassParseException)ex;
            message = pex.getMessage() != null ? String.valueOf(pex.getMessage()) + " at " : "Invalid symbol after ";
            String image = pex.currentToken;
            String token = OWLTextFormatter.getDisplayString(image == null ? "" : image);
            message = String.valueOf(message) + "\"" + token + "\"";
        } else if (ex instanceof TokenMgrError) {
            TokenMgrError error = (TokenMgrError)ex;
            message = error.getMessage();
        } else if (ex instanceof NumberFormatException) {
            message = "Please enter a number \u2265 0";
        } else {
            message = ex.toString();
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
        return message;
    }

    protected void initMiddleBar(JToolBar middleBar) {
        this.classAction.activateComboBox(this.addButton(middleBar, this.classAction));
        this.propertyAction.activateComboBox(this.addButton(middleBar, this.propertyAction));
        this.individiualAction.activateComboBox(this.addButton(middleBar, this.individiualAction));
        middleBar.addSeparator();
        this.rdfDatatypeAction = new ResourceSelectionAction("Insert datatype...", OWLIcons.getImageIcon("RDFSDatatype")){

            public Collection getSelectableResources() {
                ArrayList valids = new ArrayList(OWLSymbolPanel.this.getOWLModel().getRDFSDatatypes());
                valids.remove(OWLSymbolPanel.this.getOWLModel().getRDFXMLLiteralType());
                return valids;
            }

            public void resourceSelected(RDFResource resource) {
                OWLSymbolPanel.this.insertIndividual(resource);
            }
        };
        JButton db = this.addButton(middleBar, this.rdfDatatypeAction);
        this.rdfDatatypeAction.activateComboBox(db);
        this.trueAction = this.addAction("true", "True", "true", middleBar);
        this.falseAction = this.addAction("false", "False", "false", middleBar);
        middleBar.addSeparator();
        this.enumerationAction = new AbstractAction("Insert curly brackets for enumerations: { }", OWLIcons.getImageIcon("OWLEnumeratedClass")){

            public void actionPerformed(ActionEvent e) {
                OWLSymbolPanel.this.getSymbolEditor().insertText("{}", 1);
            }
        };
        this.addButton(middleBar, this.enumerationAction);
        this.roundBracketsAction = new AbstractAction("Insert round brackets: ( )", OWLIcons.getImageIcon("RoundBrackets")){

            public void actionPerformed(ActionEvent e) {
                OWLSymbolPanel.this.getSymbolEditor().insertText("()", 1);
            }
        };
        this.addButton(middleBar, this.roundBracketsAction);
    }

    protected void initTopBar(JToolBar topBar) {
        OWLClassDisplay renderer = this.getOWLModel().getOWLClassDisplay();
        this.allValuesFromAction = this.addAction("allValuesFrom", "OWLAllValuesFrom", renderer.getOWLAllValuesFromSymbol() + " ", topBar);
        this.someValuesFromAction = this.addAction("someValuesFrom", "OWLSomeValuesFrom", renderer.getOWLSomeValuesFromSymbol() + " ", topBar);
        this.hasValueAction = this.addAction("hasValue", "OWLHasValue", " " + renderer.getOWLHasValueSymbol() + " ", topBar);
        topBar.addSeparator();
        this.cardinalityAction = this.addAction("cardinality", "OWLCardinality", " " + renderer.getOWLCardinalitySymbol() + " ", topBar);
        this.minCardinalityAction = this.addAction("minCardinality", "OWLMinCardinality", " " + renderer.getOWLMinCardinalitySymbol() + " ", topBar);
        this.maxCardinalityAction = this.addAction("maxCardinality", "OWLMaxCardinality", " " + renderer.getOWLMaxCardinalitySymbol() + " ", topBar);
        topBar.addSeparator();
        this.intersectionOfAction = this.addAction("intersectionOf", "OWLIntersectionClass", " " + renderer.getOWLIntersectionOfSymbol() + " ", topBar);
        this.unionOfAction = this.addAction("unionOf", "OWLUnionClass", " " + renderer.getOWLUnionOfSymbol() + " ", topBar);
        this.complementOfAction = this.addAction("complementOf", "OWLComplementClass", renderer.getOWLComplementOfSymbol(), topBar);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableActions(enabled, enabled, enabled, enabled);
    }
}

