/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;
import java.util.ArrayList;

public class SetConditionTestCase
extends AbstractConditionsTableTestCase {
    public void testReplaceLastNamedSuperclassWithAnonCls() throws Exception {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        cls.addSuperclass(animalCls);
        cls.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(1));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(2));
        tableModel.setValueAt(2, this.owlModel, "not Animal");
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(this.owlThing));
        ArrayList ss = new ArrayList(cls.getSuperclasses(false));
        ss.remove(this.owlThing);
        SetConditionTestCase.assertTrue((boolean)(ss.iterator().next() instanceof OWLComplementClass));
        SetConditionTestCase.assertEquals((int)0, (int)cls.getEquivalentClasses().size());
    }

    public void testReplaceAnonSuperclassWithRestriction() throws Exception {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        cls.addSuperclass(animalCls);
        cls.addSuperclass(this.owlModel.createOWLComplementClass(animalCls));
        cls.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(1));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(2));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(3) instanceof OWLComplementClass));
        tableModel.setValueAt(3, this.owlModel, "children min 1");
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(animalCls));
        ArrayList ss = new ArrayList(cls.getSuperclasses(false));
        ss.remove(animalCls);
        SetConditionTestCase.assertTrue((boolean)(ss.iterator().next() instanceof OWLMinCardinality));
        SetConditionTestCase.assertEquals((int)0, (int)cls.getEquivalentClasses().size());
    }

    public void testReplaceNamedSuperclassWithRestriction() throws Exception {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        cls.addSuperclass(animalCls);
        cls.addSuperclass(this.owlModel.createOWLComplementClass(animalCls));
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)5, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(1));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(2));
        SetConditionTestCase.assertEquals((Object)this.owlThing, (Object)tableModel.getClass(3));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(4) instanceof OWLComplementClass));
        tableModel.setValueAt(3, this.owlModel, "children min 1");
        SetConditionTestCase.assertEquals((int)3, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(animalCls));
        SetConditionTestCase.assertEquals((int)0, (int)cls.getEquivalentClasses().size());
    }

    public void testSetNamedEquivalentClsToAnon() throws Exception {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        personCls.addEquivalentClass(menschCls);
        personCls.removeSuperclass(this.owlThing);
        menschCls.removeSuperclass(this.owlThing);
        SetConditionTestCase.assertFalse((boolean)menschCls.getSuperclasses(false).contains(this.owlThing));
        ConditionsTableModel tableModel = this.getTableModel(personCls);
        SetConditionTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertEquals((Object)menschCls, (Object)tableModel.getClass(1));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(2));
        tableModel.setValueAt(1, this.owlModel, "not Mensch");
        SetConditionTestCase.assertEquals((int)2, (int)personCls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)personCls.getEquivalentClasses().size());
        SetConditionTestCase.assertTrue((boolean)(personCls.getDefinition() instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)personCls.isSubclassOf(this.owlThing));
        SetConditionTestCase.assertEquals((int)0, (int)menschCls.getEquivalentClasses().size());
        SetConditionTestCase.assertEquals((int)1, (int)menschCls.getSuperclassCount());
        SetConditionTestCase.assertTrue((boolean)menschCls.isSubclassOf(this.owlThing));
    }

    public void testSetAnonEquivalentClsToNamed() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        cls.addEquivalentClass(this.owlModel.createOWLComplementClass(menschCls));
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(1) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(2));
        SetConditionTestCase.assertEquals((Object)this.owlThing, (Object)tableModel.getClass(3));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.setValueAt(1, this.owlModel, "Mensch");
        SetConditionTestCase.assertEquals((int)(oldClsCount - 1), (int)this.owlModel.getClsCount());
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertEquals((Object)menschCls, (Object)cls.getDefinition());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(this.owlThing));
    }

    public void testSetAnonEquivalentClsToOtherAnon() throws Exception {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass menschCls = this.owlModel.createOWLNamedClass("Mensch");
        cls.addSuperclass(animalCls);
        cls.removeSuperclass(this.owlThing);
        cls.addEquivalentClass(this.owlModel.createOWLComplementClass(menschCls));
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(1) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(2));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(3));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.setValueAt(1, this.owlModel, "not Animal");
        SetConditionTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLComplementClass));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)((OWLComplementClass)cls.getDefinition()).getComplement());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(animalCls));
    }

    public void testSetAnonEquivalentClsOperandToOtherAnon() throws Exception {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass tierCls = this.owlModel.createOWLNamedClass("Tier");
        cls.addSuperclass(animalCls);
        cls.removeSuperclass(this.owlThing);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(tierCls));
        cls.addEquivalentClass(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(1));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(2) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(3));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.setValueAt(2, this.owlModel, "not Animal");
        SetConditionTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLIntersectionClass));
        OWLIntersectionClass newDefinition = (OWLIntersectionClass)cls.getDefinition();
        ArrayList newOperands = new ArrayList(newDefinition.getOperands());
        SetConditionTestCase.assertTrue((boolean)newOperands.contains(animalCls));
        newOperands.remove(animalCls);
        SetConditionTestCase.assertTrue((boolean)(newOperands.iterator().next() instanceof OWLComplementClass));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)((OWLComplementClass)newOperands.iterator().next()).getComplement());
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(animalCls));
    }

    public void testSetNamedEquivalentClsOperandToAnon() throws Exception {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass tierCls = this.owlModel.createOWLNamedClass("Tier");
        cls.addSuperclass(animalCls);
        cls.removeSuperclass(this.owlThing);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(tierCls));
        cls.addEquivalentClass(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(1));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(2) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(3));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.setValueAt(1, this.owlModel, "not Animal");
        SetConditionTestCase.assertEquals((int)(oldClsCount + 1), (int)this.owlModel.getClsCount());
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLIntersectionClass));
        OWLIntersectionClass newDefinition = (OWLIntersectionClass)cls.getDefinition();
        ArrayList newOperands = new ArrayList(newDefinition.getOperands());
        SetConditionTestCase.assertTrue((boolean)(newOperands.get(0) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)(newOperands.get(1) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(this.owlThing));
    }

    public void testSetNamedEquivalentClsOperandToOtherNamed() throws Exception {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass tierCls = this.owlModel.createOWLNamedClass("Tier");
        cls.addSuperclass(animalCls);
        cls.removeSuperclass(this.owlThing);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(tierCls));
        cls.addEquivalentClass(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        SetConditionTestCase.assertEquals((int)4, (int)tableModel.getRowCount());
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(0));
        SetConditionTestCase.assertEquals((Object)animalCls, (Object)tableModel.getClass(1));
        SetConditionTestCase.assertTrue((boolean)(tableModel.getClass(2) instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)tableModel.isSeparator(3));
        int oldClsCount = this.owlModel.getClsCount();
        tableModel.setValueAt(1, this.owlModel, "Tier");
        SetConditionTestCase.assertEquals((int)oldClsCount, (int)this.owlModel.getClsCount());
        SetConditionTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertTrue((boolean)(cls.getDefinition() instanceof OWLIntersectionClass));
        OWLIntersectionClass newDefinition = (OWLIntersectionClass)cls.getDefinition();
        ArrayList newOperands = new ArrayList(newDefinition.getOperands());
        SetConditionTestCase.assertTrue((boolean)newOperands.contains(tierCls));
        newOperands.remove(tierCls);
        SetConditionTestCase.assertTrue((boolean)(newOperands.iterator().next() instanceof OWLComplementClass));
        SetConditionTestCase.assertTrue((boolean)cls.isSubclassOf(tierCls));
    }

    public void testSetUnchanged() throws Exception {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        cls.setDefinition(restriction);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        tableModel.setValueAt(1, this.owlModel, "children min 1");
        SetConditionTestCase.assertEquals((int)1, (int)cls.getEquivalentClasses().size());
        SetConditionTestCase.assertEquals((Object)restriction, (Object)cls.getDefinition());
    }

    public void testSetToItself() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        tableModel.setValueAt(2, this.owlModel, cls.getName());
        SetConditionTestCase.assertSize(1, cls.getSuperclasses(false));
        SetConditionTestCase.assertEquals((Object)this.owlThing, (Object)cls.getFirstSuperclass());
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
    }
}

