/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameEditor;
import java.awt.FlowLayout;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstanceNameComponent
extends JPanel
implements Disposable {
    private FrameListener frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent event) {
            InstanceNameComponent.this.updateAll();
        }
    };
    private Instance instance;
    private JLabel leftLabel = ComponentFactory.createLabel();
    private JLabel rightLabel = ComponentFactory.createLabel();
    private InstanceNameEditor textField = new InstanceNameEditor();

    public InstanceNameComponent() {
        FlowLayout layout = new FlowLayout(0, 2, 2);
        this.setLayout(layout);
        this.add(this.leftLabel);
        this.add(this.textField);
        this.add(this.rightLabel);
    }

    public void dispose() {
        this.removeListener();
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected String getTypeText(Instance instance) {
        StringBuffer typeText = new StringBuffer();
        Iterator i = instance.getDirectTypes().iterator();
        while (i.hasNext()) {
            Cls type = (Cls)i.next();
            typeText.append(type.getBrowserText());
            if (!i.hasNext()) continue;
            typeText.append(", ");
        }
        return typeText.toString();
    }

    private void removeListener() {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.frameListener);
        }
    }

    public void setInstance(Instance instance) {
        this.removeListener();
        this.textField.setInstance(instance);
        this.instance = instance;
        if (instance != null) {
            instance.addFrameListener(this.frameListener);
        }
        this.updateAll();
    }

    private void updateAll() {
        if (this.instance != null) {
            this.leftLabel.setIcon(this.instance.getIcon());
            String browserText = this.instance.getBrowserText();
            String name = this.instance.getName();
            if (name.equals(browserText)) {
                this.leftLabel.setText("");
            } else {
                this.leftLabel.setText(String.valueOf(browserText) + " -   Internal name:");
            }
            this.textField.setText(name);
            String typeText = this.getTypeText(this.instance);
            this.rightLabel.setText("  (instance of " + typeText + ")  ");
            this.setEditable(this.instance.isEditable());
        } else {
            this.leftLabel.setIcon(null);
            this.leftLabel.setText("");
            this.rightLabel.setText("");
            this.textField.setText("");
            this.setEditable(false);
        }
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void setEditable(boolean value) {
        this.textField.setEditable(value);
    }

    protected String getInvalidTextDescription(String text) {
        return this.textField.getInvalidTextDescription(text);
    }

    protected boolean validateText(String text) {
        return this.textField.validateText(text);
    }

    protected void commitChanges() {
        this.textField.attemptCommit();
    }
}

