/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.results;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class ResultsPanel
extends JPanel
implements Disposable {
    public static MouseListener mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent event) {
            AbstractButton button = this.getButton(event);
            button.setBorderPainted(button.isEnabled());
        }

        public void mouseExited(MouseEvent event) {
            this.getButton(event).setBorderPainted(false);
        }

        private AbstractButton getButton(MouseEvent event) {
            return (AbstractButton)event.getSource();
        }
    };
    private OWLModel owlModel;
    protected JToolBar toolBar;

    protected ResultsPanel() {
        this((OWLModel)null);
    }

    protected ResultsPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.setLayout(new BorderLayout());
        this.toolBar = ComponentFactory.createToolBar();
        this.toolBar.setOrientation(1);
        this.toolBar.add(Box.createVerticalGlue());
        AbstractAction closeAction = new AbstractAction("Close", OWLIcons.getCloseIcon()){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.close();
            }
        };
        this.addButton(closeAction);
        this.addSeparator();
        this.add("Center", new JPanel());
        this.toolBar.add(Box.createVerticalBox());
        this.add("West", this.toolBar);
    }

    protected JButton addButton(Action action) {
        JButton button = ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)action);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon instanceof OverlayIcon) {
            button.setDisabledIcon(((OverlayIcon)icon).getGrayedIcon());
        }
        if (action instanceof ResourceSelectionAction) {
            ((ResourceSelectionAction)action).activateComboBox(button);
        }
        this.toolBar.add((Component)button, 1);
        return button;
    }

    protected void addSeparator() {
        this.toolBar.add((Component)new JToolBar.Separator(), 1);
    }

    public void close() {
        ResultsPanelManager.closeResultsPanel(this.owlModel, this);
    }

    public void dispose() {
    }

    public Icon getIcon() {
        return null;
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public abstract String getTabName();

    public boolean isReplaceableBy(ResultsPanel resultsPanel) {
        return this.getTabName().equals(resultsPanel.getTabName());
    }

    public void setCenterComponent(Component component) {
        this.add("Center", component);
    }

    public void showHostInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            this.showHostResource((RDFResource)instance);
        }
    }

    public void showHostResource(RDFResource resource) {
        ResultsPanelManager.showHostResource(resource);
    }

    public void showTriple(Triple triple) {
        ResultsPanelManager.showTriple(triple);
    }
}

