/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.testing.AbstractOWLTestAction;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OWLTestInstanceAction
extends AbstractOWLTestAction {
    private Selectable selectable;

    public OWLTestInstanceAction(OWLModel owlModel, OWLTestManager testManager, Selectable selectable) {
        super(owlModel, testManager, "Run ontology tests on this resource", OWLIcons.getImageIcon("TestInstance"));
        this.selectable = selectable;
        selectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLTestInstanceAction.this.updateStatus();
            }
        });
    }

    protected OWLTestResultsPanel getTestResultsPanel(OWLModel owlModel, List results) {
        Instance instance = (Instance)this.selectable.getSelection().iterator().next();
        return new OWLTestResultsPanel(owlModel, results, instance, true);
    }

    protected List run(OWLTest[] tests, Task task) {
        ArrayList results = new ArrayList();
        for (Object o : this.selectable.getSelection()) {
            if (!(o instanceof RDFResource)) continue;
            RDFResource instance = (RDFResource)o;
            int i = 0;
            while (i < tests.length) {
                OWLTest test = tests[i];
                if (test instanceof RDFSClassTest && instance instanceof RDFSClass) {
                    results.addAll(((RDFSClassTest)test).test((RDFSClass)instance));
                }
                if (test instanceof RDFPropertyTest && instance instanceof OWLProperty) {
                    results.addAll(((RDFPropertyTest)test).test((OWLProperty)instance));
                }
                if (test instanceof RDFResourceTest) {
                    results.addAll(((RDFResourceTest)test).test(instance));
                }
                ++i;
            }
        }
        return results;
    }

    private void updateStatus() {
        Collection selection = this.selectable.getSelection();
        this.setEnabled(selection.size() > 0);
    }
}

