/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import org.w3c.rdf.digest.Digest;
import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.DigestUtil;
import org.w3c.rdf.digest.Digestable;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class RDFDigestUtil {
    private static String algorithm = "SHA-1";

    public static Digest computeModelDigest(Model model) throws DigestException, ModelException {
        Enumeration enumeration = model.elements();
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RDFDigestUtil: no implementation for " + algorithm + " on your Java plattform");
        }
        Digest[] digestArray = new Digest[model.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            Digest digest = RDFDigestUtil.getStatementDigest(statement);
            digestArray[n++] = digest;
        }
        Arrays.sort(digestArray, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    byte[] byArray = ((Digest)object).getDigestBytes();
                    byte[] byArray2 = ((Digest)object2).getDigestBytes();
                    if (byArray.length != byArray2.length) {
                        return byArray.length - byArray2.length;
                    }
                    int n = 0;
                    while (n < byArray.length) {
                        if (byArray[n] != byArray2[n]) {
                            return byArray[n] - byArray2[n];
                        }
                        ++n;
                    }
                }
                catch (DigestException digestException) {}
                return 0;
            }
        });
        int n2 = 0;
        while (n2 < n) {
            messageDigest.update(digestArray[n2].getDigestBytes());
            ++n2;
        }
        try {
            return DigestUtil.createFromBytes(algorithm, messageDigest.digest());
        }
        catch (DigestException digestException) {
            throw new InternalError(digestException.toString());
        }
    }

    public static Digest computeNodeDigest(RDFNode rDFNode) throws ModelException {
        try {
            return DigestUtil.computeDigest(algorithm, rDFNode.getLabel());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RDFDigestUtil: no implementation for " + algorithm + " on your Java plattform");
        }
    }

    public static Digest computeStatementDigest(Statement statement) throws DigestException, ModelException {
        byte[] byArray = RDFDigestUtil.getNodeDigest(statement.subject()).getDigestBytes();
        byte[] byArray2 = RDFDigestUtil.getNodeDigest(statement.predicate()).getDigestBytes();
        byte[] byArray3 = RDFDigestUtil.getNodeDigest(statement.object()).getDigestBytes();
        int n = byArray.length;
        byte[] byArray4 = new byte[n * 3];
        System.arraycopy(byArray, 0, byArray4, 0, n);
        System.arraycopy(byArray2, 0, byArray4, n, n);
        if (statement.object() instanceof Resource) {
            System.arraycopy(byArray3, 0, byArray4, n * 2, n);
        } else {
            int n2 = 0;
            while (n2 < n) {
                byArray4[n * 2 + (n2 + 1) % n] = byArray3[n2];
                ++n2;
            }
        }
        try {
            return DigestUtil.computeDigest(algorithm, byArray4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RDFDigestUtil: no implementation for " + algorithm + " on your Java plattform");
        }
    }

    public static String getDigestAlgorithm() {
        return algorithm;
    }

    public static Digest getModelDigest(Model model) throws DigestException, ModelException {
        return model instanceof Digestable ? ((Digestable)((Object)model)).getDigest() : RDFDigestUtil.computeModelDigest(model);
    }

    public static Digest getNodeDigest(RDFNode rDFNode) throws DigestException, ModelException {
        return rDFNode instanceof Digestable ? ((Digestable)((Object)rDFNode)).getDigest() : RDFDigestUtil.computeNodeDigest(rDFNode);
    }

    public static Digest getStatementDigest(Statement statement) throws DigestException, ModelException {
        return statement instanceof Digestable ? ((Digestable)((Object)statement)).getDigest() : RDFDigestUtil.computeStatementDigest(statement);
    }

    public static String modelDigestToURI(Digest digest) throws DigestException {
        return "urn:rdf:" + algorithm + "-" + DigestUtil.toHexString(digest);
    }

    public static void setDigestAlgorithm(String string) {
        algorithm = string;
    }

    public static String statementDigestToURI(Digest digest) throws DigestException {
        return "urn:rdf:" + algorithm + "-" + DigestUtil.toHexString(digest);
    }
}

