/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.tests;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;
import java.util.logging.Level;

public class IndividualTests
extends AbstractJenaTestCase {
    public void testTypesQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLIndividual indA = clsA.createOWLIndividual("iA");
            OWLIndividual indThing = this.owlModel.getOWLThingClass().createOWLIndividual("iThing");
            indA.addRDFType(clsB);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            Collection iATypes = reasoner.getIndividualTypes(indA, null);
            IndividualTests.assertTrue((boolean)iATypes.contains(clsA));
            IndividualTests.assertTrue((boolean)iATypes.contains(clsB));
            Collection thingTypes = reasoner.getIndividualTypes(indThing, null);
            IndividualTests.assertTrue((boolean)thingTypes.contains(this.owlModel.getOWLThingClass()));
        }
        catch (DIGReasonerException e) {
            IndividualTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testIndividualsBelongingToClassQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLIndividual indA = clsA.createOWLIndividual("iA");
            OWLIndividual indThing = this.owlModel.getOWLThingClass().createOWLIndividual("iThing");
            indA.addRDFType(clsB);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            IndividualTests.assertTrue((boolean)reasoner.getIndividualsBelongingToClass(clsA, null).contains(indA));
            IndividualTests.assertTrue((boolean)reasoner.getIndividualsBelongingToClass(clsB, null).contains(indA));
            IndividualTests.assertTrue((boolean)reasoner.getIndividualsBelongingToClass(this.owlModel.getOWLThingClass(), null).contains(indThing));
        }
        catch (DIGReasonerException e) {
            IndividualTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }
}

