/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;

public class ImportMetaClsesTestCase
extends AbstractOWLImporterTestCase {
    public void testImportMetaclass() {
        OWLNamedClass oldMetaCls = this.owlModel.createOWLNamedSubclass("MetaCls", this.owlModel.getOWLNamedClassClass());
        OWLDatatypeProperty oldSlot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDint());
        oldSlot.setDomain(oldMetaCls);
        OWLNamedClass oldCls = (OWLNamedClass)oldMetaCls.createInstance("Cls");
        oldCls.setPropertyValue(oldSlot, new Integer(42));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newMetaCls = kb.getCls(oldMetaCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportMetaClsesTestCase.assertNotNull((Object)newMetaCls);
        ImportMetaClsesTestCase.assertEquals((int)1, (int)newMetaCls.getDirectSuperclassCount());
        ImportMetaClsesTestCase.assertEquals((Object)kb.getDefaultClsMetaCls(), newMetaCls.getDirectSuperclasses().iterator().next());
        Cls newCls = kb.getCls(oldCls.getName());
        ImportMetaClsesTestCase.assertNotNull((Object)newCls);
        ImportMetaClsesTestCase.assertEquals((Object)newMetaCls, (Object)newCls.getDirectType());
        ImportMetaClsesTestCase.assertEquals((Object)new Integer(42), (Object)newCls.getDirectOwnSlotValue(newSlot));
    }
}

