/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class DefaultRDFSLiteralTestCase
extends AbstractJenaTestCase {
    public void testInt() {
        RDFSDatatype datatype = this.owlModel.getXSDint();
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("42", datatype);
        DefaultRDFSLiteralTestCase.assertEquals((Object)datatype, (Object)literal.getDatatype());
        DefaultRDFSLiteralTestCase.assertEquals((String)"42", (String)literal.getString());
        DefaultRDFSLiteralTestCase.assertEquals((int)42, (int)literal.getInt());
        RDFSLiteral otherLiteral = this.owlModel.createRDFSLiteral("42", datatype);
        DefaultRDFSLiteralTestCase.assertEquals((Object)literal, (Object)otherLiteral);
        DefaultRDFSLiteralTestCase.assertEquals((int)literal.hashCode(), (int)otherLiteral.hashCode());
    }

    public void testSetAndGetLanguage() {
        RDFSDatatype datatype = this.owlModel.getXSDstring();
        OWLDatatypeProperty property = this.owlModel.createAnnotationOWLDatatypeProperty("property");
        property.setRange(datatype);
        RDFSNamedClass subject = this.owlModel.createRDFSNamedClass("Cls");
        subject.addPropertyValue(property, "Test");
        DefaultRDFSLiteralTestCase.assertEquals((Object)"Test", (Object)subject.getPropertyValue(property));
        subject.setPropertyValue(property, this.owlModel.createRDFSLiteralOrString("Text", "de"));
        Object value = subject.getPropertyValue(property);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)(value instanceof RDFSLiteral));
        RDFSLiteral literal = (RDFSLiteral)value;
        DefaultRDFSLiteralTestCase.assertEquals((String)"Text", (String)literal.getString());
        DefaultRDFSLiteralTestCase.assertEquals((String)"de", (String)literal.getLanguage());
        DefaultRDFSLiteralTestCase.assertEquals((Object)this.owlModel.getXSDstring(), (Object)literal.getDatatype());
    }

    public void testSetOptimized() {
        RDFSDatatype datatype = this.owlModel.getXSDstring();
        OWLDatatypeProperty property = this.owlModel.createAnnotationOWLDatatypeProperty("property");
        property.setRange(datatype);
        RDFSNamedClass subject = this.owlModel.createRDFSNamedClass("Cls");
        RDFSLiteral stringLiteral = this.owlModel.createRDFSLiteral("Text");
        subject.setPropertyValue(property, stringLiteral);
        Object stringValue = subject.getPropertyValue(property);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)(stringValue instanceof String));
        DefaultRDFSLiteralTestCase.assertEquals((Object)"Text", (Object)stringValue);
        RDFSLiteral intLiteral = this.owlModel.createRDFSLiteral(new Integer(42));
        subject.setPropertyValue(property, intLiteral);
        Object intValue = subject.getPropertyValue(property);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)(intValue instanceof Integer));
        DefaultRDFSLiteralTestCase.assertEquals((Object)new Integer(42), (Object)intValue);
        RDFSLiteral uintLiteral = this.owlModel.createRDFSLiteral("42", this.owlModel.getRDFSDatatypeByURI(XSDDatatype.XSDunsignedInt.getURI()));
        subject.setPropertyValue(property, uintLiteral);
        Object uintValue = subject.getPropertyValue(property);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)(uintValue instanceof RDFSLiteral));
        DefaultRDFSLiteralTestCase.assertEquals((Object)uintLiteral, (Object)uintValue);
    }

    public void testAnyURI() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setDomain(cls);
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        String uri1 = "http://aldi.de";
        String uri2 = "http://lidl.de";
        RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByName("xsd:anyURI");
        individual.addPropertyValue(property, this.owlModel.createRDFSLiteral(uri1, datatype));
        individual.addPropertyValue(property, this.owlModel.createRDFSLiteral(uri2, datatype));
        Collection values = individual.getPropertyValues(property);
        DefaultRDFSLiteralTestCase.assertSize(2, values);
        DefaultRDFSLiteralTestCase.assertContains((Object)this.owlModel.createRDFSLiteral(uri1, datatype), values);
        DefaultRDFSLiteralTestCase.assertContains((Object)this.owlModel.createRDFSLiteral(uri2, datatype), values);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)(values.iterator().next() instanceof RDFSLiteral));
    }

    public void testDoubleIsHandledAsRDFSLiteral() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setDomain(cls);
        RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByName("xsd:double");
        DefaultRDFSLiteralTestCase.assertNotNull((Object)datatype);
        property.setRange(datatype);
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("4.2", datatype);
        individual.setPropertyValue(property, literal);
        Object value = individual.getPropertyValue(property);
        DefaultRDFSLiteralTestCase.assertEquals((Object)value, (Object)literal);
    }

    public void testBooleanTrue() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setRange(this.owlModel.getXSDboolean());
        this.owlThing.setPropertyValue(property, Boolean.TRUE);
        RDFSLiteral literal = this.owlThing.getPropertyValueLiteral(property);
        DefaultRDFSLiteralTestCase.assertTrue((boolean)literal.getBoolean());
    }

    public void testWeirdBoolean() {
        RDFSDatatype bool = this.owlModel.getXSDboolean();
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("1", bool);
        DefaultRDFSLiteralTestCase.assertEquals((Object)bool, (Object)literal.getDatatype());
        DefaultRDFSLiteralTestCase.assertTrue((boolean)literal.getBoolean());
    }

    public void testIntWithWhitespaces() {
        String raw = "   \n\t\t10 \n";
        RDFSLiteral literal = this.owlModel.createRDFSLiteral(raw, this.owlModel.getXSDint());
        DefaultRDFSLiteralTestCase.assertEquals((int)10, (int)literal.getInt());
    }

    public void testInvalidPlainValues() {
        RDFSLiteral intLiteral = this.owlModel.createRDFSLiteral("", this.owlModel.getXSDint());
        DefaultRDFSLiteralTestCase.assertEquals((Object)new Integer(0), (Object)intLiteral.getPlainValue());
        RDFSLiteral floatLiteral = this.owlModel.createRDFSLiteral("", this.owlModel.getXSDfloat());
        DefaultRDFSLiteralTestCase.assertEquals((Object)new Float(0.0f), (Object)floatLiteral.getPlainValue());
        RDFSLiteral booleanLiteral = this.owlModel.createRDFSLiteral("", this.owlModel.getXSDboolean());
        DefaultRDFSLiteralTestCase.assertEquals((Object)Boolean.FALSE, (Object)booleanLiteral.getPlainValue());
    }

    public void testCreateLiteralWithAnonymousDatatype() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype(this.owlModel.getNextAnonymousResourceName());
        RDFProperty subDatatypeOfProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        datatype.setPropertyValue(subDatatypeOfProperty, this.owlModel.getXSDint());
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("10", datatype);
        DefaultRDFSLiteralTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)literal.getDatatype());
    }

    public void testCompareFloats() {
        RDFSLiteral b;
        RDFSLiteral a = this.owlModel.createRDFSLiteral("2.1", this.owlModel.getXSDfloat());
        DefaultRDFSLiteralTestCase.assertTrue((a.compareTo(b = this.owlModel.createRDFSLiteral("4.3", this.owlModel.getXSDfloat())) < 0 ? 1 : 0) != 0);
        DefaultRDFSLiteralTestCase.assertTrue((a.compareTo(a) == 0 ? 1 : 0) != 0);
        DefaultRDFSLiteralTestCase.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
    }

    public void testCompareInts() {
        RDFSLiteral b;
        RDFSLiteral a = this.owlModel.createRDFSLiteral("2", this.owlModel.getXSDinteger());
        DefaultRDFSLiteralTestCase.assertTrue((a.compareTo(b = this.owlModel.createRDFSLiteral("4", this.owlModel.getXSDinteger())) < 0 ? 1 : 0) != 0);
        DefaultRDFSLiteralTestCase.assertTrue((a.compareTo(a) == 0 ? 1 : 0) != 0);
        DefaultRDFSLiteralTestCase.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
    }
}

