/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

class OWLDeprecatedClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    OWLDeprecatedClassPostProcessor(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.kb = owlModel;
        this.updateDeprecatedClasses();
    }

    private void updateDeprecatedClasses() {
        Slot directTypesSlot = this.kb.getSlot(":DIRECT-TYPE");
        Slot directInstancesSlot = this.kb.getSlot(":DIRECT-INSTANCES");
        RDFProperty rdfTypeProperty = this.owlModel.getRDFTypeProperty();
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:DeprecatedClass");
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        Iterator tripleStores = tripleStoreModel.listUserTripleStores();
        while (tripleStores.hasNext()) {
            TripleStore tripleStore = (TripleStore)tripleStores.next();
            NarrowFrameStore nfs = tripleStore.getNarrowFrameStore();
            Set clses = nfs.getFrames((Slot)rdfTypeProperty, null, false, (Object)metaclass);
            for (Cls cls : clses) {
                if (cls.getDirectTypes().size() == 1) {
                    OWLNamedClass extraMetaclass = this.owlModel.getOWLNamedClassClass();
                    if (!nfs.getValues((Frame)cls, (Slot)rdfTypeProperty, null, false).contains(extraMetaclass)) {
                        nfs.addValues((Frame)cls, (Slot)rdfTypeProperty, null, false, (Collection)Collections.singleton(extraMetaclass));
                    }
                    nfs.addValues((Frame)cls, directTypesSlot, null, false, (Collection)Collections.singleton(extraMetaclass));
                    nfs.addValues((Frame)extraMetaclass, directInstancesSlot, null, false, (Collection)Collections.singleton(cls));
                }
                nfs.removeValue((Frame)cls, directTypesSlot, null, false, (Object)metaclass);
                nfs.removeValue((Frame)metaclass, directInstancesSlot, null, false, (Object)cls);
                nfs.addValues((Frame)cls, directTypesSlot, null, false, (Collection)Collections.singleton(metaclass));
                nfs.addValues((Frame)metaclass, directInstancesSlot, null, false, (Collection)Collections.singleton(cls));
            }
            OWLJavaFactoryUpdater.run(this.owlModel, clses);
        }
    }
}

