/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.tests.AbstractTripleStoreTestCase;

public class CreateRDFSSubClassOfTestCase
extends AbstractTripleStoreTestCase {
    public void testDefaultSuperclass() {
        String name = "Class";
        RDFResource c = this.createRDFResource(name);
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass cls = this.owlModel.getOWLNamedClass(name);
        CreateRDFSSubClassOfTestCase.assertSize(1, cls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)this.owlThing, cls.getDirectSuperclasses());
    }

    public void testDefaultSuperclassDespiteRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        String name = "Class";
        RDFResource c = this.createRDFResource(name);
        RDFResource restriction = this.createRDFResource(null);
        this.ts.add(c, this.owlModel.getRDFSSubClassOfProperty(), restriction);
        this.ts.add(restriction, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(restriction, this.owlModel.getRDFProperty("owl:cardinality"), new Integer(1));
        this.ts.add(restriction, this.owlModel.getRDFProperty("owl:onProperty"), property);
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass cls = this.owlModel.getOWLNamedClass(name);
        CreateRDFSSubClassOfTestCase.assertSize(2, cls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)this.owlThing, cls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)restriction, cls.getDirectSuperclasses());
    }

    public void testSimpleSuperclass() {
        RDFResource subclass = this.createRDFResource("subclass");
        RDFResource superclass = this.createRDFResource("superclass");
        this.ts.add(subclass, this.owlModel.getRDFSSubClassOfProperty(), superclass);
        this.ts.add(subclass, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(superclass, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass subcls = this.owlModel.getOWLNamedClass(subclass.getName());
        OWLNamedClass supercls = this.owlModel.getOWLNamedClass(superclass.getName());
        CreateRDFSSubClassOfTestCase.assertSize(1, supercls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)this.owlThing, supercls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertSize(1, subcls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)supercls, subcls.getDirectSuperclasses());
        CreateRDFSSubClassOfTestCase.assertSize(1, supercls.getDirectSubclasses());
        CreateRDFSSubClassOfTestCase.assertContains((Object)subcls, supercls.getDirectSubclasses());
    }
}

