/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToDefinedClassAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MinCardiZeroTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    private static boolean warn = true;
    private static boolean fix = false;

    public String getDocumentation() {
        return "Find classes that have a min cardi zero restriction on them";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Min Cardi Zero";
    }

    public List test(RDFSClass aClass) {
        if (aClass instanceof OWLNamedClass) {
            OWLNamedClass namedClass = (OWLNamedClass)aClass;
            Collection allRestrictions = namedClass.getRestrictions();
            for (OWLRestriction restr : allRestrictions) {
                if (!(restr instanceof OWLMinCardinality) || ((OWLMinCardinality)restr).getCardinality() != 0) continue;
                return Collections.singletonList(new DefaultOWLTestResult("Min cardinality zero does not mean anything in OWL", aClass, 2, this));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean repair(OWLTestResult testResult) {
        boolean result = false;
        this.handleUserWarning();
        if (fix) {
            OWLNamedClass namedClass = (OWLNamedClass)testResult.getHost();
            OWLModel owlModel = namedClass.getOWLModel();
            Collection allRestrictions = namedClass.getRestrictions();
            for (OWLRestriction restr : allRestrictions) {
                if (!(restr instanceof OWLMinCardinality) || ((OWLMinCardinality)restr).getCardinality() != 0) continue;
                OWLMinCardinality cloneRestr = (OWLMinCardinality)restr.createClone();
                cloneRestr.setCardinality(1);
                String newClassName = String.valueOf(namedClass.getBrowserText()) + "That" + cloneRestr.getOnProperty().getBrowserText();
                if (cloneRestr.getQualifier() != null) {
                    newClassName = String.valueOf(newClassName) + cloneRestr.getQualifier().getBrowserText();
                }
                OWLNamedClass newClass = owlModel.createOWLNamedClass(newClassName);
                newClass.addSuperclass(namedClass);
                newClass.removeSuperclass(owlModel.getOWLThingClass());
                newClass.addSuperclass(cloneRestr);
                ConvertToDefinedClassAction.performAction(newClass);
                namedClass.removeSuperclass(restr);
                result = true;
            }
        }
        return result;
    }

    private void handleUserWarning() {
        if (warn) {
            JPanel panel = new JPanel(new BorderLayout(6, 6));
            JLabel question = new JLabel("Fixing min cardinality 0 restrictions creates new defined subclasses. Are you sure you want to do this?");
            JCheckBox doNotWarnAgainBox = new JCheckBox("do not warn me again this session", false);
            panel.add((Component)question, "North");
            panel.add((Component)doNotWarnAgainBox, "South");
            boolean bl = fix = JOptionPane.showConfirmDialog(Application.getMainWindow(), panel, "Fix min cardi 0", 0, 2) == 0;
            if (doNotWarnAgainBox.isSelected()) {
                warn = false;
            }
        }
    }
}

