/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableColumns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RDFPropertiesTableModel
extends AbstractTableModel
implements Disposable,
RDFPropertiesTableColumns {
    private RDFSNamedClass cls;
    private ClassListener classListener = new ClassAdapter(){

        public void addedToUnionDomainOf(RDFSClass cls, RDFProperty property) {
            property.addPropertyValueListener(RDFPropertiesTableModel.this.valueListener);
            RDFPropertiesTableModel.this.listenedToProperties.add(property);
            RDFPropertiesTableModel.this.refill();
        }

        public void removedFromUnionDomainOf(RDFSClass cls, RDFProperty property) {
            property.removePropertyValueListener(RDFPropertiesTableModel.this.valueListener);
            RDFPropertiesTableModel.this.listenedToProperties.remove(property);
            RDFPropertiesTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            RDFPropertiesTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            RDFPropertiesTableModel.this.refill();
        }
    };
    private int directCount = 0;
    private Collection listenedToProperties = new HashSet();
    private List properties = new ArrayList();
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            int row = RDFPropertiesTableModel.this.getRow(property);
            RDFPropertiesTableModel.this.fireTableCellUpdated(row, 1);
            RDFPropertiesTableModel.this.fireTableCellUpdated(row, 0);
            RDFPropertiesTableModel.this.fireTableCellUpdated(row, 2);
        }
    };

    public void dispose() {
        this.unregisterValueListener();
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
    }

    private void fill() {
        ArrayList directProperties = new ArrayList(this.cls.getUnionDomainProperties());
        Collections.sort(directProperties, new ResourceComparator());
        this.properties.addAll(directProperties);
        this.directCount = this.properties.size();
        ArrayList<RDFProperty> os = new ArrayList<RDFProperty>();
        for (RDFProperty property : this.cls.getUnionDomainProperties(true)) {
            if (property.isSystem() || directProperties.contains(property)) continue;
            os.add(property);
        }
        Collections.sort(os, new ResourceComparator());
        this.properties.addAll(os);
        this.fireTableRowsInserted(0, this.getRowCount());
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == 2) {
            return RDFResource.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Property";
        }
        if (column == 1) {
            return "Cardinality";
        }
        if (column == 2) {
            return "Type";
        }
        return super.getColumnName(column);
    }

    public RDFProperty getRDFProperty(int row) {
        return (RDFProperty)this.properties.get(row);
    }

    public int getRow(RDFProperty property) {
        return this.properties.indexOf(property);
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        RDFProperty property = this.getRDFProperty(rowIndex);
        if (columnIndex == 0) {
            return property;
        }
        if (columnIndex == 1) {
            return property.isFunctional() ? "Single" : "Multiple";
        }
        if (columnIndex == 2) {
            return property.getRange();
        }
        return null;
    }

    public boolean isDirectProperty(int row) {
        return row < this.directCount;
    }

    private void refill() {
        int count = this.getRowCount();
        this.properties.clear();
        if (count > 0) {
            this.fireTableRowsDeleted(0, count - 1);
        }
        this.fill();
    }

    public void setClass(RDFSNamedClass cls) {
        this.unregisterValueListener();
        if (this.cls != null) {
            cls.removeClassListener(this.classListener);
        }
        this.cls = cls;
        if (cls != null) {
            cls.addClassListener(this.classListener);
        }
        this.refill();
    }

    private void unregisterValueListener() {
        for (RDFProperty property : this.listenedToProperties) {
            property.removePropertyValueListener(this.valueListener);
        }
    }
}

