/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import java.util.ArrayList;

public class AnnotationsTableModelTestCase
extends AbstractJenaTestCase {
    public void testSimpleTableModel() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        c.addPropertyValue(this.owlModel.getRDFSLabelProperty(), "Value");
        AnnotationsTableModel tableModel = new AnnotationsTableModel(c);
        int defPropSize = tableModel.getDefaultProperties().size();
        AnnotationsTableModelTestCase.assertEquals((int)(defPropSize + 1), (int)tableModel.getRowCount());
        AnnotationsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(defPropSize, 1));
        AnnotationsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(defPropSize, 2));
        AnnotationsTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(defPropSize, 0));
    }

    public void testEditableSystemResources() {
        RDFProperty property = this.owlModel.getRDFSLabelProperty();
        OWLNamedClass resource = this.owlModel.getOWLNamedClassClass();
        AnnotationsTableModel tableModel = new AnnotationsTableModel(resource);
        int defPropSize = tableModel.getDefaultProperties().size();
        AnnotationsTableModelTestCase.assertEquals((int)defPropSize, (int)tableModel.getRowCount());
        String value = "Value";
        resource.addPropertyValue(property, value);
        AnnotationsTableModelTestCase.assertEquals((int)(defPropSize + 1), (int)tableModel.getRowCount());
        AnnotationsTableModelTestCase.assertEquals((Object)value, (Object)tableModel.getValueAt(defPropSize, 1));
        AnnotationsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(defPropSize, 1));
        String newValue = "NewValue";
        tableModel.setValueAt("NewValue", defPropSize, 1);
        AnnotationsTableModelTestCase.assertSize(defPropSize, resource.getPropertyValues(property));
        AnnotationsTableModelTestCase.assertContains((Object)"NewValue", resource.getPropertyValues(property));
    }

    public void testEditableImports() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        RDFResource resource = this.owlModel.getRDFResource("travel:Accommodation");
        AnnotationsTableModelTestCase.assertNotNull((Object)resource);
        AnnotationsTableModel tableModel = new AnnotationsTableModel(resource);
        ArrayList defProps = new ArrayList(tableModel.getDefaultProperties());
        defProps.removeAll(resource.getRDFProperties());
        int defPropSize = defProps.size();
        AnnotationsTableModelTestCase.assertEquals((int)(defPropSize + 1), (int)tableModel.getRowCount());
        AnnotationsTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 1));
        resource.addPropertyValue(this.owlModel.getOWLVersionInfoProperty(), "Value");
        AnnotationsTableModelTestCase.assertEquals((int)(defPropSize + 2), (int)tableModel.getRowCount());
        AnnotationsTableModelTestCase.assertEquals((Object)this.owlModel.getOWLVersionInfoProperty(), (Object)tableModel.getPredicate(defPropSize));
        AnnotationsTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(defPropSize, 1));
        AnnotationsTableModelTestCase.assertTrue((boolean)tableModel.isDeleteEnabled(defPropSize));
    }

    public void testEditXMLLiteral() {
        OWLNamedClass subject = this.owlThing;
        OWLDatatypeProperty predicate = this.owlModel.createAnnotationOWLDatatypeProperty("property");
        RDFSDatatype type = this.owlModel.getRDFXMLLiteralType();
        predicate.setRange(type);
        String lexicalValue = "<foo>value</foo>";
        RDFSLiteral literal = this.owlModel.createRDFSLiteral(lexicalValue, type);
        subject.setPropertyValue(predicate, literal);
        AnnotationsTableModel tableModel = new AnnotationsTableModel(subject);
        int defPropSize = tableModel.getDefaultProperties().size();
        AnnotationsTableModelTestCase.assertEquals((int)(defPropSize + 1), (int)tableModel.getRowCount());
        AnnotationsTableModelTestCase.assertEquals((Object)lexicalValue, (Object)tableModel.getValueAt(1, 1));
        String newLexicalValue = "<bar>value</bar>";
        tableModel.setValueAt(newLexicalValue, defPropSize, 1);
        AnnotationsTableModelTestCase.assertSize(1, subject.getPropertyValues(predicate));
        Object value = subject.getPropertyValue(predicate);
        AnnotationsTableModelTestCase.assertTrue((boolean)(value instanceof RDFSLiteral));
        RDFSLiteral newLiteral = (RDFSLiteral)value;
        AnnotationsTableModelTestCase.assertEquals((String)newLexicalValue, (String)newLiteral.getString());
        AnnotationsTableModelTestCase.assertEquals((Object)type, (Object)newLiteral.getDatatype());
    }
}

