/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.ForcedURLRetrievalRepository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportEntry;
import java.net.URI;
import java.net.URL;

public class URLImportEntry
extends AbstractImportEntry {
    private URL url;

    public URLImportEntry(URL url) {
        this.url = url;
    }

    public boolean isPossibleToImport() {
        try {
            OntologyNameExtractor extractor = new OntologyNameExtractor(this.url.openConnection().getInputStream(), this.url);
            URI uri = extractor.getOntologyName();
            if (uri != null) {
                this.setRepository(new HTTPRepository(this.url));
            } else if (extractor.isRDFRootElementPresent()) {
                uri = new URI(this.url.toString());
                this.setRepository(new ForcedURLRetrievalRepository(this.url));
            } else {
                throw new IllegalArgumentException("The document pointed to by " + this.url + " does not " + "appear to be a valid ontology.");
            }
            this.setOntologyURI(uri);
            return true;
        }
        catch (Exception e) {
            this.addError(e);
            this.setOntologyURI(null);
            this.setRepository(null);
            return false;
        }
    }

    public Repository getRepositoryToAdd() {
        return this.getRepository();
    }
}

