/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;

public abstract class AbstractPropertyValuesWidget
extends AbstractSlotWidget {
    private PropertyValuesComponent component;

    protected abstract PropertyValuesComponent createComponent(RDFProperty var1);

    public void initialize() {
        this.component = this.createComponent((RDFProperty)this.getSlot());
        this.add((Component)((Object)this.component));
    }

    public static boolean isInvalid(RDFResource subject, RDFProperty predicate, Collection values) {
        for (Object value : values) {
            if (subject.isValidPropertyValue(predicate, value)) continue;
            return true;
        }
        RDFSClass type = subject.getRDFType();
        if (type instanceof OWLNamedClass) {
            OWLNamedClass namedClass = (OWLNamedClass)type;
            int min = namedClass.getMinCardinality(predicate);
            if (min >= 0 && values.size() < min) {
                return true;
            }
            int max = namedClass.getMaxCardinality(predicate);
            if (max >= 0 && values.size() > max) {
                return true;
            }
            if (values.size() == 0 && namedClass.getSomeValuesFrom(predicate) != null) {
                return true;
            }
        }
        return false;
    }

    public void setInstance(Instance newInstance) {
        RDFResource subject = null;
        if (newInstance instanceof RDFResource) {
            subject = (RDFResource)newInstance;
        }
        this.component.setSubject(subject);
        super.setInstance(newInstance);
    }

    public void setValues(Collection values) {
        super.setValues(values);
        this.component.valuesChanged();
    }

    protected void updateBorder(Collection values) {
        if (OWLUI.isConstraintChecking((OWLModel)this.getKnowledgeBase())) {
            RDFResource subject = (RDFResource)this.getInstance();
            RDFProperty predicate = (RDFProperty)this.getSlot();
            if (subject != null && predicate != null) {
                boolean invalid = AbstractPropertyValuesWidget.isInvalid(subject, predicate, values);
                if (invalid) {
                    this.setInvalidValueBorder();
                } else {
                    this.setNormalBorder();
                }
                this.repaint();
            }
        }
    }
}

