/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.LocalProjectAction;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class IncludeProject
extends LocalProjectAction {
    public IncludeProject() {
        super(ResourceKey.PROJECT_INCLUDE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = IncludeProject.getProjectManager().getMainPanel();
        Project project = IncludeProject.getProjectManager().getCurrentProject();
        if (project != null) {
            JFileChooser jFileChooser = ComponentFactory.createFileChooser("Included Project", "pprj");
            int n = jFileChooser.showOpenDialog(jComponent);
            switch (n) {
                case -1: {
                    break;
                }
                case 1: {
                    break;
                }
                case 0: {
                    ArrayList<URI> arrayList = new ArrayList<URI>(project.getDirectIncludedProjectURIs());
                    URI uRI = jFileChooser.getSelectedFile().toURI();
                    String string = project.getName() + ".pprj";
                    if (uRI.equals(string)) {
                        String string2 = LocalizedText.getText(ResourceKey.INCLUDE_PROJECT_FAILED_DIALOG_RECURSIVE_INCLUDE_TEXT);
                        ModalDialog.showMessageDialog(jComponent, string2);
                        break;
                    }
                    if (arrayList.contains(uRI)) {
                        String string3 = LocalizedText.getText(ResourceKey.INCLUDE_PROJECT_FILED_DIALOG_ALREADY_INCLUDED_TEXT);
                        ModalDialog.showMessageDialog(jComponent, string3);
                        break;
                    }
                    arrayList.add(uRI);
                    IncludeProject.getProjectManager().changeIncludedProjectURIsRequest(arrayList);
                    break;
                }
                default: {
                    Log.getLogger().warning("Bad value: " + n);
                }
            }
        }
    }
}

