/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateFacetCommand
extends AbstractCommand {
    private boolean loadDefaults;
    private String name;
    private FrameID id;
    private Collection types;
    private Facet createdFacet;

    CreateFacetCommand(FrameStore frameStore, FrameID frameID, String string, Collection collection, boolean bl) {
        super(frameStore);
        this.id = frameID;
        this.name = string;
        this.types = new ArrayList(collection);
        this.loadDefaults = bl;
    }

    public Object doIt() {
        this.createdFacet = this.getDelegate().createFacet(this.id, this.name, this.types, this.loadDefaults);
        this.id = this.createdFacet.getFrameID();
        this.name = this.getDelegate().getFrameName(this.createdFacet);
        this.setDescription("Create facet " + CreateFacetCommand.getText(this.createdFacet));
        return this.createdFacet;
    }

    public void undoIt() {
        this.getDelegate().deleteFacet(this.createdFacet);
        this.createdFacet.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createFacet(this.id, this.name, this.types, this.loadDefaults);
        this.createdFacet.markDeleted(false);
    }
}

