/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.ProtegeRmiClassLoaderSpi;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.ServerRmiSocketFactory;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.LocalizeFrameStoreHandler;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Server
extends UnicastRemoteObject
implements RemoteServer {
    private static Server serverInstance;
    private Map _nameToOpenProjectMap = new HashMap();
    private Map _projectToServerProjectMap = new HashMap();
    private KnowledgeBase _systemKb;
    private Slot _nameSlot;
    private Slot _passwordSlot;
    private Slot _locationSlot;
    private Cls _userCls;
    private Cls _projectCls;
    private List _sessions = new ArrayList();
    private URI _baseURI;
    private Map _sessionToProjectsMap = new HashMap();
    private Thread _updateThread;
    private URI metaprojectURI;
    private static final int NO_SAVE = -1;
    private int _saveIntervalMsec = -1;
    private static final String SAVE_INTERVAL_OPTION = "-saveIntervalSec=";
    private static final String NOPRELOAD_OPTION = "-nopreload";
    private static final String OPTION_CHAR = "-";
    private boolean preload = true;
    private ProjectPluginManager _projectPluginManager = new ProjectPluginManager();

    public static void main(String[] stringArray) {
        try {
            Server.startServer(stringArray);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "server startup failed", exception);
        }
    }

    public static void startServer(String[] stringArray) throws IOException {
        Server.startServer(stringArray, new ServerRmiSocketFactory());
    }

    public static void startServer(String[] stringArray, RMISocketFactory rMISocketFactory) throws IOException {
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", ProtegeRmiClassLoaderSpi.class.getName());
        RMISocketFactory.setSocketFactory(rMISocketFactory);
        SystemUtilities.initialize();
        serverInstance = new Server(stringArray);
        Log.getLogger().info("Protege server ready to accept connections...");
    }

    public static Server getInstance() {
        return serverInstance;
    }

    public static String getBoundName() {
        return Text.getProgramTextName();
    }

    protected static String getLocalBoundName() {
        return Server.getBoundName();
    }

    private static Registry getRegistry() throws RemoteException {
        int n = Integer.getInteger("protege.rmi.registry.port", 1099);
        return LocateRegistry.getRegistry(null, n, RMISocketFactory.getSocketFactory());
    }

    private void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseArg(stringArray[i]);
        }
    }

    protected void parseArg(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            this.extractSaveInterval(string);
        } else if (string.startsWith(NOPRELOAD_OPTION)) {
            this.preload = false;
        } else if (string.startsWith(OPTION_CHAR)) {
            this.printUsage();
        } else {
            this.extractMetaProjectLocation(string);
        }
    }

    private void extractSaveInterval(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            String string2 = string.substring(SAVE_INTERVAL_OPTION.length());
            int n = Integer.parseInt(string2);
            Log.getLogger().config("Save interval sec=" + n);
            if (n > 0) {
                this._saveIntervalMsec = n * 1000;
            }
        } else {
            this.printUsage();
        }
    }

    protected void extractMetaProjectLocation(String string) {
        this.metaprojectURI = URIUtilities.createURI(string);
    }

    protected void printUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("usage: java -cp protege.jar edu.stanford.smi.protege.server.Server [options] <metaproject>");
        stringBuffer.append("\n\tOptions:");
        stringBuffer.append("\n\t\t-saveIntervalSec=<nseconds>");
        stringBuffer.append("\n\t\t\tSave any dirty projects every n minutes (only needed for file based projects)");
        stringBuffer.append("\n\t\t-nopreload");
        stringBuffer.append("\n\t\t\tDon't preload projects.");
        System.err.println(stringBuffer.toString());
        System.exit(-1);
    }

    public Server(String[] stringArray) throws RemoteException, IOException {
        this.parseArgs(stringArray);
        this.initialize();
    }

    public void reinitialize() throws RemoteException {
        Log.getLogger().info("Server reinitializing");
        this.clear();
        this.initialize();
    }

    private void clear() {
        this._nameToOpenProjectMap.clear();
        this._projectToServerProjectMap.clear();
        this._sessions.clear();
        this._sessionToProjectsMap.clear();
        this.stopProjectUpdateThread();
    }

    private void initialize() throws RemoteException {
        ArrayList arrayList = new ArrayList();
        Project project = Project.loadProjectFromURI(this.metaprojectURI, arrayList);
        if (!arrayList.isEmpty()) {
            throw new RuntimeException(arrayList.iterator().next().toString());
        }
        this._systemKb = project.getKnowledgeBase();
        this._projectCls = this._systemKb.getCls("Project");
        this._userCls = this._systemKb.getCls("User");
        this._nameSlot = this._systemKb.getSlot("name");
        this._passwordSlot = this._systemKb.getSlot("password");
        this._locationSlot = this._systemKb.getSlot("location");
        this.bindName();
        this.dumpProjects();
        this.startProjectUpdateThread();
    }

    private void dumpProjects() {
        for (String string : this.getAvailableProjectNames(null)) {
            if (this.preload) {
                Log.getLogger().info("Loading project " + string);
                this.createProject(string);
                continue;
            }
            Log.getLogger().info("Found project " + string);
        }
    }

    protected void bindName() throws RemoteException {
        try {
            String string = Server.getLocalBoundName();
            Server.getRegistry().rebind(string, this);
            this._baseURI = new URI("rmi://" + Server.getMachineName() + "/" + string);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.getMessage());
        }
    }

    private static String getMachineName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Log.getLogger().severe(Log.toString(unknownHostException));
            string = "localhost";
        }
        return string;
    }

    public RemoteSession openSession(String string, String string2, String string3) {
        Session session = null;
        if (this.isValid(string, string3)) {
            session = new Session(string, string2);
            this._sessions.add(session);
        }
        return session;
    }

    public void closeSession(RemoteSession remoteSession) {
        this._sessions.remove(remoteSession);
    }

    public boolean isActive(RemoteSession remoteSession) {
        return this._sessions.contains(remoteSession);
    }

    public RemoteServerProject openProject(String string, RemoteSession remoteSession) {
        ServerProject serverProject = null;
        Project project = this.getOrCreateProject(string);
        if (project != null) {
            serverProject = this.getServerProject(project);
            if (serverProject == null) {
                serverProject = this.createServerProject(string, project);
                this.addServerProject(project, serverProject);
            }
            this.recordConnection(remoteSession, serverProject);
        }
        return serverProject;
    }

    private void recordConnection(RemoteSession remoteSession, ServerProject serverProject) {
        ArrayList<ServerProject> arrayList = (ArrayList<ServerProject>)this._sessionToProjectsMap.get(remoteSession);
        if (arrayList == null) {
            arrayList = new ArrayList<ServerProject>();
            this._sessionToProjectsMap.put(remoteSession, arrayList);
        }
        arrayList.add(serverProject);
        serverProject.register(remoteSession);
    }

    private void recordDisconnection(RemoteSession remoteSession, RemoteServerProject remoteServerProject) {
        Collection collection = (Collection)this._sessionToProjectsMap.get(remoteSession);
        collection.remove(remoteServerProject);
        this._sessions.remove(remoteSession);
        Log.getLogger().info("removing session: " + remoteSession);
    }

    private ServerProject getServerProject(String string) {
        Project project = this.getProject(string);
        return project == null ? null : this.getServerProject(project);
    }

    private ServerProject createServerProject(String string, Project project) {
        ServerProject serverProject = null;
        try {
            serverProject = new ServerProject(this, this.getURI(string), project);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
        return serverProject;
    }

    private URI getURI(String string) {
        String string2 = FileUtilities.urlEncode(string);
        return this._baseURI.resolve(string2);
    }

    public void disconnectFromProject(RemoteServerProject remoteServerProject, RemoteSession remoteSession) {
        this.recordDisconnection(remoteSession, remoteServerProject);
    }

    private ServerProject getServerProject(Project project) {
        return (ServerProject)this._projectToServerProjectMap.get(project);
    }

    private void addServerProject(Project project, RemoteServerProject remoteServerProject) {
        this._projectToServerProjectMap.put(project, remoteServerProject);
    }

    private Project getProject(String string) {
        return (Project)this._nameToOpenProjectMap.get(string);
    }

    private Project getOrCreateProject(String string) {
        Project project = this.getProject(string);
        if (project == null) {
            project = this.createProject(string);
        }
        return project;
    }

    private Project createProject(String string) {
        Project project = null;
        for (Instance instance : this._systemKb.getInstances(this._projectCls)) {
            String string2 = (String)instance.getOwnSlotValue(this._nameSlot);
            if (!string2.equals(string)) continue;
            String string3 = (String)instance.getOwnSlotValue(this._locationSlot);
            string3 = Server.localizeLocation(string3);
            URI uRI = URIUtilities.createURI(string3);
            project = Project.loadProjectFromURI(uRI, new ArrayList(), true);
            this._projectPluginManager.afterLoad(project);
            Server.localizeProject(project);
            this._nameToOpenProjectMap.put(string, project);
            break;
        }
        return project;
    }

    private static String localizeLocation(String string) {
        if (File.separatorChar != '\\') {
            string = string.replace('\\', File.separatorChar);
        }
        return string;
    }

    private static void localizeProject(Project project) {
        Server.localizeKB(project.getKnowledgeBase());
        Server.localizeKB(project.getInternalProjectKnowledgeBase());
    }

    private static void localizeKB(KnowledgeBase knowledgeBase) {
        FrameStore frameStore = new LocalizeFrameStoreHandler(knowledgeBase).newFrameStore();
        knowledgeBase.insertFrameStore(frameStore);
    }

    public Collection getAvailableProjectNames(RemoteSession remoteSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Instance instance : this._systemKb.getInstances(this._projectCls)) {
            String string = (String)instance.getOwnSlotValue(this._locationSlot);
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                String string2 = (String)instance.getOwnSlotValue(this._nameSlot);
                arrayList.add(string2);
                continue;
            }
            Log.getLogger().warning("Missing project at " + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Collection getCurrentSessions(String string, RemoteSession remoteSession) {
        ServerProject serverProject = this.getServerProject(string);
        Collection collection = serverProject == null ? Collections.EMPTY_LIST : this.getCurrentSessions(serverProject);
        return collection;
    }

    public Collection getCurrentSessions(RemoteServerProject remoteServerProject) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        for (Map.Entry entry : this._sessionToProjectsMap.entrySet()) {
            Session session;
            Collection collection = (Collection)entry.getValue();
            if (!collection.contains(remoteServerProject) || !Server.isCurrent(session = (Session)entry.getKey())) continue;
            arrayList.add(session);
        }
        return arrayList;
    }

    private static boolean isCurrent(Session session) {
        return true;
    }

    private boolean isValid(String string, String string2) {
        boolean bl = false;
        for (Instance instance : this._systemKb.getInstances(this._userCls)) {
            String string3;
            String string4 = (String)instance.getOwnSlotValue(this._nameSlot);
            if (!string4.equals(string) || !(string3 = (String)instance.getOwnSlotValue(this._passwordSlot)).equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String toString() {
        return "Server";
    }

    private void startProjectUpdateThread() {
        if (this._saveIntervalMsec != -1) {
            this._updateThread = new Thread("Save Projects"){

                public void run() {
                    try {
                        while (Server.this._updateThread == this) {
                            1.sleep(Server.this._saveIntervalMsec);
                            Server.this.saveAllProjects();
                        }
                    }
                    catch (Throwable throwable) {
                        Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                    }
                }
            };
            this._updateThread.setDaemon(true);
            this._updateThread.start();
        }
    }

    private void saveAllProjects() {
        for (Map.Entry entry : this._projectToServerProjectMap.entrySet()) {
            Project project = (Project)entry.getKey();
            ServerProject serverProject = (ServerProject)entry.getValue();
            if (!serverProject.isDirty()) continue;
            Server.save(serverProject, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(ServerProject serverProject, Project project) {
        Log.getLogger().info("saving " + project);
        ArrayList arrayList = new ArrayList();
        RemoteServerFrameStore remoteServerFrameStore = serverProject.getDomainKbFrameStore(null);
        synchronized (remoteServerFrameStore) {
            RemoteServerFrameStore remoteServerFrameStore2 = serverProject.getProjectKbFrameStore(null);
            synchronized (remoteServerFrameStore2) {
                project.save(arrayList);
            }
        }
        serverProject.setClean();
        Server.dumpErrors(project, arrayList);
    }

    private static void dumpErrors(Project project, Collection collection) {
        if (!collection.isEmpty()) {
            Log.getLogger().warning("Unable to save project " + project);
            for (Object e : collection) {
                Log.getLogger().warning("\t" + e.toString());
            }
        }
    }

    public void shutdown() {
        Log.getLogger().info("Received shutdown request.");
        this.saveAllProjects();
        Thread thread = new Thread(){

            public void run() {
                try {
                    SystemUtilities.sleepMsec(100);
                    Log.getLogger().info("Server exiting.");
                    System.exit(0);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.INFO, "Exception caught", exception);
                }
            }
        };
        thread.start();
    }

    private void stopProjectUpdateThread() {
        this._updateThread = null;
    }
}

