/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.BorderLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

class ConfigureOptionsPanel
extends AbstractValidatableComponent {
    private Project _project;
    private JCheckBox _hiddenFramesComponent;
    private JCheckBox _confirmOnRemoveComponent;
    private JCheckBox _isEditableComponent;
    private JCheckBox _updateModificationSlotsComponent;
    private JCheckBox journalingEnabledCheckBox;
    private JCheckBox prettyPrintSlotWidgetLabelsCheckBox;
    private JCheckBox tabbedInstanceFormCheckBox;

    ConfigureOptionsPanel(Project project) {
        this._project = project;
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        box.add(this.createHiddenClassesComponent());
        box.add(this.createConfirmOnRemoveComponent());
        box.add(this.createIsEditableComponent());
        box.add(this.createUpdateModificationSlotsComponent());
        box.add(this.createJournalingEnabledCheckBox());
        box.add(this.createPrettyPrintSlotWidgetLabelsCheckBox());
        box.add(this.createTabbedInstanceFormComponent());
        this.add(box);
    }

    private JComponent createJournalingEnabledCheckBox() {
        this.journalingEnabledCheckBox = ComponentFactory.createCheckBox();
        this.journalingEnabledCheckBox.setText("Enable Journaling");
        this.journalingEnabledCheckBox.setSelected(this._project.isJournalingEnabled());
        return this.journalingEnabledCheckBox;
    }

    private JComponent createPrettyPrintSlotWidgetLabelsCheckBox() {
        this.prettyPrintSlotWidgetLabelsCheckBox = ComponentFactory.createCheckBox();
        this.prettyPrintSlotWidgetLabelsCheckBox.setText("Capitalize Slot Widget Labels");
        this.prettyPrintSlotWidgetLabelsCheckBox.setSelected(this._project.getPrettyPrintSlotWidgetLabels());
        return this.prettyPrintSlotWidgetLabelsCheckBox;
    }

    private JComponent createConfirmOnRemoveComponent() {
        this._confirmOnRemoveComponent = ComponentFactory.createCheckBox("Display Confirmation Dialog on 'Remove' Operations");
        ConfigureOptionsPanel.setValue(this._confirmOnRemoveComponent, this._project.getDisplayConfirmationOnRemove());
        return this._confirmOnRemoveComponent;
    }

    private JComponent createHiddenClassesComponent() {
        this._hiddenFramesComponent = ComponentFactory.createCheckBox("Display Hidden Frames");
        ConfigureOptionsPanel.setValue(this._hiddenFramesComponent, this._project.getDisplayHiddenClasses());
        return this._hiddenFramesComponent;
    }

    private JComponent createIsEditableComponent() {
        this._isEditableComponent = ComponentFactory.createCheckBox("Allow Knowledge-Base Changes");
        ConfigureOptionsPanel.setValue(this._isEditableComponent, !this._project.isReadonly());
        return this._isEditableComponent;
    }

    private JComponent createUpdateModificationSlotsComponent() {
        this._updateModificationSlotsComponent = ComponentFactory.createCheckBox("Update Modification Slots");
        ConfigureOptionsPanel.setValue(this._updateModificationSlotsComponent, this._project.getUpdateModificationSlots());
        return this._updateModificationSlotsComponent;
    }

    private JComponent createTabbedInstanceFormComponent() {
        this.tabbedInstanceFormCheckBox = ComponentFactory.createCheckBox("Used Tabbed Forms for Multi-Type Instances");
        ConfigureOptionsPanel.setValue(this.tabbedInstanceFormCheckBox, this._project.getTabbedInstanceFormLayout());
        return this.tabbedInstanceFormCheckBox;
    }

    private static boolean getValue(JCheckBox jCheckBox) {
        return jCheckBox.isSelected();
    }

    public void saveContents() {
        this._project.setDisplayHiddenClasses(ConfigureOptionsPanel.getValue(this._hiddenFramesComponent));
        this._project.setDisplayConfirmationOnRemove(ConfigureOptionsPanel.getValue(this._confirmOnRemoveComponent));
        this._project.setIsReadonly(!ConfigureOptionsPanel.getValue(this._isEditableComponent));
        this._project.setUpdateModificationSlots(ConfigureOptionsPanel.getValue(this._updateModificationSlotsComponent));
        this._project.setJournalingEnabled(ConfigureOptionsPanel.getValue(this.journalingEnabledCheckBox));
        this._project.setPrettyPrintSlotWidgetLabels(ConfigureOptionsPanel.getValue(this.prettyPrintSlotWidgetLabelsCheckBox));
        this._project.setTabbedInstanceFormLayout(ConfigureOptionsPanel.getValue(this.tabbedInstanceFormCheckBox));
    }

    private static void setValue(JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
    }

    public boolean validateContents() {
        return true;
    }
}

