/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Assert;
import java.awt.Dimension;
import java.awt.Rectangle;

public class InstanceUtilities {
    private static final String CLASS_DIMENSION = "Dimension";
    private static final String SLOT_X = "x";
    private static final String SLOT_Y = "y";
    private static final String SLOT_WIDTH = "width";
    private static final String SLOT_HEIGHT = "height";

    public static Dimension getDimension(Instance instance) {
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_DIMENSION);
        Dimension dimension = new Dimension();
        dimension.width = InstanceUtilities.getInt(instance, SLOT_WIDTH);
        dimension.height = InstanceUtilities.getInt(instance, SLOT_HEIGHT);
        return dimension;
    }

    private static int getInt(Instance instance, String string) {
        Object object = ModelUtilities.getDirectOwnSlotValue(instance, string);
        Integer n = object instanceof String ? new Integer((String)object) : (Integer)object;
        return n == null ? 0 : n;
    }

    public static Rectangle getRectangle(Instance instance) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = InstanceUtilities.getInt(instance, SLOT_X);
        rectangle.y = InstanceUtilities.getInt(instance, SLOT_Y);
        rectangle.width = InstanceUtilities.getInt(instance, SLOT_WIDTH);
        rectangle.height = InstanceUtilities.getInt(instance, SLOT_HEIGHT);
        return rectangle;
    }

    public static void setDimension(Instance instance, Dimension dimension) {
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_DIMENSION);
        InstanceUtilities.setInt(instance, SLOT_WIDTH, dimension.width);
        InstanceUtilities.setInt(instance, SLOT_HEIGHT, dimension.height);
    }

    private static void setInt(Instance instance, String string, int n) {
        ModelUtilities.setOwnSlotValue(instance, string, new Integer(n));
    }

    public static void setRectangle(Instance instance, Rectangle rectangle) {
        InstanceUtilities.setInt(instance, SLOT_X, rectangle.x);
        InstanceUtilities.setInt(instance, SLOT_Y, rectangle.y);
        InstanceUtilities.setInt(instance, SLOT_WIDTH, rectangle.width);
        InstanceUtilities.setInt(instance, SLOT_HEIGHT, rectangle.height);
    }
}

