/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;

public class XSDDuration
extends AbstractDateTime {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};
    private int[][] fDuration = null;

    public XSDDuration(Object object) {
        super(object);
    }

    public int getYears() {
        return this.data[0];
    }

    public int getMonths() {
        return this.data[1];
    }

    public int getDays() {
        return this.data[2];
    }

    public int getHours() {
        return this.data[3];
    }

    public int getMinutes() {
        return this.data[4];
    }

    public int getFullSeconds() {
        return this.data[5];
    }

    public double getSeconds() {
        return (double)this.data[5] + this.fractionalSeconds;
    }

    public double getTimePart() {
        return (double)(((long)this.data[3] * 60L + (long)this.data[4]) * 60L) + this.getSeconds();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = 1;
        if (this.data[0] < 0) {
            stringBuffer.append('-');
            n = -1;
        }
        stringBuffer.append('P');
        stringBuffer.append(n * this.data[0]);
        stringBuffer.append('Y');
        stringBuffer.append(n * this.data[1]);
        stringBuffer.append('M');
        stringBuffer.append(n * this.data[2]);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append(n * this.data[3]);
        stringBuffer.append('H');
        stringBuffer.append(n * this.data[4]);
        stringBuffer.append('M');
        stringBuffer.append(n * this.data[5]);
        stringBuffer.append('.');
        stringBuffer.append(n * this.data[6]);
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        int[] nArray4;
        short s = 2;
        short s2 = this.compareOrder(nArray, nArray2);
        if (s2 == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][8];
        }
        if ((s2 = this.compareOrder(nArray4 = this.addDuration(nArray, 0, this.fDuration[0]), nArray3 = this.addDuration(nArray2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 1, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 1, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 2, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 2, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 3, this.fDuration[0]);
        nArray3 = this.addDuration(nArray2, 3, this.fDuration[1]);
        s = this.compareOrder(nArray4, nArray3);
        s2 = this.compareResults(s2, s, bl);
        return s2;
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 2;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }

    private int[] addDuration(int[] nArray, int n, int[] nArray2) {
        this.resetDateObj(nArray2);
        int n2 = DATETIMES[n][1] + nArray[1];
        nArray2[1] = XSDDuration.modulo(n2, 1, 13);
        int n4 = XSDDuration.fQuotient(n2, 1, 13);
        nArray2[0] = DATETIMES[n][0] + nArray[0] + n4;
        n2 = DATETIMES[n][5] + nArray[5];
        n4 = XSDDuration.fQuotient(n2, 60);
        nArray2[5] = XSDDuration.mod(n2, 60, n4);
        n2 = DATETIMES[n][4] + nArray[4] + n4;
        n4 = XSDDuration.fQuotient(n2, 60);
        nArray2[4] = XSDDuration.mod(n2, 60, n4);
        n2 = DATETIMES[n][3] + nArray[3] + n4;
        n4 = XSDDuration.fQuotient(n2, 24);
        nArray2[3] = XSDDuration.mod(n2, 24, n4);
        nArray2[2] = DATETIMES[n][2] + nArray[2] + n4;
        while (true) {
            n2 = XSDDuration.maxDayInMonthFor(nArray2[0], nArray2[1]);
            if (nArray2[2] < 1) {
                nArray2[2] = nArray2[2] + XSDDuration.maxDayInMonthFor(nArray2[0], nArray2[1] - 1);
                n4 = -1;
            } else {
                if (nArray2[2] <= n2) break;
                nArray2[2] = nArray2[2] - n2;
                n4 = 1;
            }
            n2 = nArray2[1] + n4;
            nArray2[1] = XSDDuration.modulo(n2, 1, 13);
            nArray2[0] = nArray2[0] + XSDDuration.fQuotient(n2, 1, 13);
        }
        nArray2[7] = 90;
        return nArray2;
    }
}

