/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.graph.test.TestReifier;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.SmallGraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestGraph
extends GraphTestBase {
    public TestGraph(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestGraph.class);
        testSuite.addTest((Test)TestGraph.suite(MetaTestGraph.class, GraphMem.class));
        testSuite.addTest((Test)TestGraph.suite(TestReifier.class, GraphMem.class));
        testSuite.addTest((Test)TestGraph.suite(MetaTestGraph.class, SmallGraphMem.class));
        testSuite.addTest((Test)TestGraph.suite(TestReifier.class, SmallGraphMem.class));
        testSuite.addTest((Test)TestGraph.suite(MetaTestGraph.class, WrappedGraphMem.class));
        testSuite.addTest((Test)TestGraph.suite(TestReifier.class, WrappedGraphMem.class));
        return testSuite;
    }

    public static TestSuite suite(Class clazz, Class clazz2) {
        return MetaTestGraph.suite(clazz, clazz2);
    }

    public void testWrappedSame() {
        GraphMem graphMem = new GraphMem();
        WrappedGraph wrappedGraph = new WrappedGraph(graphMem);
        TestGraph.graphAdd(graphMem, "a trumps b; c eats d");
        TestGraph.assertIsomorphic(graphMem, wrappedGraph);
        TestGraph.graphAdd(wrappedGraph, "i write this; you read that");
        TestGraph.assertIsomorphic(wrappedGraph, graphMem);
    }

    public void testListSubjectsDoesntUseFind() {
        final boolean[] blArray = new boolean[]{false};
        GraphMem graphMem = new GraphMem(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                blArray[0] = true;
                return super.find(tripleMatch);
            }
        };
        ExtendedIterator extendedIterator = graphMem.queryHandler().subjectsFor(null, null);
        Set set = CollectionFactory.createHashedSet();
        while (extendedIterator.hasNext()) {
            set.add(extendedIterator.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)blArray[0]);
    }

    public void testListPredicatesDoesntUseFind() {
        final boolean[] blArray = new boolean[]{false};
        GraphMem graphMem = new GraphMem(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                blArray[0] = true;
                return super.find(tripleMatch);
            }
        };
        ExtendedIterator extendedIterator = graphMem.queryHandler().predicatesFor(null, null);
        Set set = CollectionFactory.createHashedSet();
        while (extendedIterator.hasNext()) {
            set.add(extendedIterator.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)blArray[0]);
    }

    public void testListObjectsDoesntUseFind() {
        final boolean[] blArray = new boolean[]{false};
        GraphMem graphMem = new GraphMem(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                blArray[0] = true;
                return super.find(tripleMatch);
            }
        };
        ExtendedIterator extendedIterator = graphMem.queryHandler().objectsFor(null, null);
        Set set = CollectionFactory.createHashedSet();
        while (extendedIterator.hasNext()) {
            set.add(extendedIterator.next());
        }
        TestGraph.assertFalse((String)"find should not have been called", (boolean)blArray[0]);
    }

    public static class WrappedGraphMem
    extends WrappedGraph {
        public WrappedGraphMem(ReificationStyle reificationStyle) {
            super(new GraphMem(reificationStyle));
        }
    }
}

