/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.BadURIReference;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.XMLHandler;

class ARPQname
extends Token {
    final String nameSpace;
    final String local;
    final String qName;

    ARPQname(int n, Location location, String string, String string2, String string3) {
        super(n, location);
        this.qName = string3;
        this.nameSpace = string;
        this.local = string2;
    }

    ARPQname(String string, String string2) {
        super(15, null);
        this.nameSpace = string;
        this.local = string2;
        this.qName = null;
    }

    String prefix() {
        int n = this.qName.indexOf(58);
        return n == -1 ? "" : this.qName.substring(0, n);
    }

    URIReference asURIReference(XMLHandler xMLHandler) throws ParseException {
        URIReference uRIReference;
        try {
            uRIReference = new URIReference(this.nameSpace + this.local);
        }
        catch (MalformedURIException malformedURIException) {
            try {
                xMLHandler.documentContext.resolve(this.location, this.nameSpace + this.local);
                if (this.nameSpace.length() == 0) {
                    xMLHandler.parseWarning(104, this.location, "Element node must be qualified.");
                } else {
                    xMLHandler.parseWarning(109, this.location, "The use of relative URIs in namespaces has been deprecated by the World Wide Web Consortium.");
                }
            }
            catch (MalformedURIException malformedURIException2) {
                xMLHandler.parseWarning(107, this.location, "Bad URI <" + this.nameSpace + this.local + "> in qname: " + malformedURIException.getMessage());
            }
            uRIReference = new BadURIReference(this.nameSpace + this.local);
        }
        return uRIReference;
    }
}

