/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.ResultBindingIterator;
import com.hp.hpl.jena.rdql.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResultBindingImpl
implements ResultBinding {
    ResultBindingImpl parent = null;
    List varNames = new ArrayList();
    List values = new ArrayList();
    List causalTriples = null;
    Query query = null;

    public ResultBindingImpl(ResultBindingImpl resultBindingImpl) {
        this.parent = resultBindingImpl;
    }

    public ResultBindingImpl() {
        this(null);
    }

    public int add(String string, Value value) {
        this.varNames.add(string);
        this.values.add(value);
        this.check();
        return this.varNames.size() - 1;
    }

    public int add(String string, RDFNode rDFNode) {
        this.varNames.add(string);
        this.values.add(rDFNode);
        this.check();
        return this.varNames.size() - 1;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addTriple(Statement statement) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
        }
        this.causalTriples.add(statement);
    }

    public Set getTriples() {
        HashSet hashSet = new HashSet();
        this.getTriples(hashSet);
        return hashSet;
    }

    private void getTriples(Collection collection) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
            if (this.query != null) {
                Model model = this.query.getSource();
                try {
                    Iterator iterator = this.query.getTriplePatterns().iterator();
                    while (iterator.hasNext()) {
                        Triple triple = (Triple)iterator.next();
                        Triple triple2 = QueryEngine.substituteIntoTriple(triple, this);
                        RDFNode rDFNode = QueryEngine.convertGraphNodeToRDFNode(triple2.getSubject(), model);
                        RDFNode rDFNode2 = QueryEngine.convertGraphNodeToRDFNode(triple2.getPredicate(), model);
                        if (rDFNode2 instanceof Resource) {
                            rDFNode2 = model.createProperty(((Resource)rDFNode2).getURI());
                        }
                        RDFNode rDFNode3 = QueryEngine.convertGraphNodeToRDFNode(triple2.getObject(), model);
                        Statement statement = model.createStatement((Resource)rDFNode, (Property)rDFNode2, rDFNode3);
                        this.causalTriples.add(statement);
                    }
                }
                catch (Exception exception) {
                    System.err.println("ResultBindingImpl.getTriples: Substitution error: " + exception);
                }
            }
        }
        if (this.causalTriples == null) {
            return;
        }
        collection.addAll(this.causalTriples);
    }

    public Model mergeTriples(Model model) {
        Set set = this.getTriples();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            model.add((Statement)iterator.next());
        }
        return model;
    }

    public Iterator names() {
        return new ResultBindingIterator(this);
    }

    public ResultBindingIterator iterator() {
        return new ResultBindingIterator(this);
    }

    public Object get(String string) {
        return this.lookup(string, 0);
    }

    private Object lookup(String string, int n) {
        for (int i = n; i < this.varNames.size(); ++i) {
            if (!string.equals((String)this.varNames.get(i))) continue;
            Object e = this.values.get(i);
            if (e instanceof RDFNode) {
                return e;
            }
            if (!(e instanceof Node)) continue;
            return QueryEngine.convertGraphNodeToRDFNode((Node)e, this.query.getSource());
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(string, 0);
    }

    void setParent(ResultBindingImpl resultBindingImpl) {
        this.parent = resultBindingImpl;
    }

    public int size() {
        int n = this.varNames.size();
        if (this.parent != null) {
            n += this.parent.size();
        }
        return n;
    }

    public void check() {
        for (int i = 0; i < this.varNames.size(); ++i) {
            String string = (String)this.varNames.get(i);
            Object object = this.lookup(string, i + 1);
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.varNames.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(" + this.varNames.get(i) + ", " + this.values.get(i) + ")");
        }
        if (this.parent != null && (string = this.parent.toString()) != null && string.length() != 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

