/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLConsistencyTest;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class OWLUnitTest
extends TestCase {
    public static ReasonerFactory[] reasonerFactories = new ReasonerFactory[]{OWLFBRuleReasonerFactory.theInstance(), OWLMicroReasonerFactory.theInstance(), OWLMiniReasonerFactory.theInstance()};
    public static final String[] reasonerNames = new String[]{"full", "Micro", "Mini"};
    public static final int FB = 1;
    public static final int MINI = 2;
    public static final int MICRO = 4;
    public static final int INCONSISTENT = 1;
    public static final int WARNINGS = 2;
    public static final int CLEAN = 3;
    public static TestDef[] testDefs = new TestDef[]{new TestDef("localtests/ManifestSubclass001.rdf", 7), new TestDef("equivalentClass/Manifest001.rdf", 7), new TestDef("equivalentClass/Manifest002.rdf", 7), new TestDef("equivalentClass/Manifest003.rdf", 7), new TestDef("equivalentClass/Manifest004.rdf", 3), new TestDef("equivalentClass/Manifest005.rdf", 7), new TestDef("localtests/ManifestRestriction001.rdf", 7), new TestDef("intersectionOf/Manifest001.rdf", 7), new TestDef("localtests/Manifest001.rdf", 7), new TestDef("localtests/Manifest002.rdf", 7), new TestDef("unionOf/Manifest001.rdf", 7), new TestDef("SymmetricProperty/Manifest001.rdf", 7), new TestDef("SymmetricProperty/Manifest001.rdf", 7), new TestDef("inverseOf/Manifest001.rdf", 7), new TestDef("TransitiveProperty/Manifest001.rdf", 7), new TestDef("localtests/Manifest005.rdf", 7), new TestDef("FunctionalProperty/Manifest001.rdf", 3), new TestDef("FunctionalProperty/Manifest002.rdf", 3), new TestDef("FunctionalProperty/Manifest003.rdf", 7), new TestDef("InverseFunctionalProperty/Manifest001.rdf", 3), new TestDef("InverseFunctionalProperty/Manifest002.rdf", 3), new TestDef("InverseFunctionalProperty/Manifest003.rdf", 7), new TestDef("I5.1/Manifest001.rdf", 3), new TestDef("rdf-charmod-uris/Manifest.rdf", 7), new TestDef("I4.6/Manifest003.rdf", 7), new TestDef("I5.5/Manifest001.rdf", 7), new TestDef("I5.5/Manifest002.rdf", 7), new TestDef("I5.5/Manifest003.rdf", 7), new TestDef("I5.5/Manifest004.rdf", 7), new TestDef("inverseOf/Manifest001.rdf", 7), new TestDef("TransitiveProperty/Manifest001.rdf", 7), new TestDef("equivalentProperty/Manifest001.rdf", 7), new TestDef("equivalentProperty/Manifest002.rdf", 7), new TestDef("equivalentProperty/Manifest003.rdf", 7), new TestDef("I5.24/Manifest001.rdf", 7), new TestDef("I5.24/Manifest002-mod.rdf", 7), new TestDef("equivalentProperty/Manifest006.rdf", 7), new TestDef("I5.2/Manifest002.rdf", 3), new TestDef("differentFrom/Manifest001.rdf", 7), new TestDef("disjointWith/Manifest001.rdf", 7), new TestDef("disjointWith/Manifest002.rdf", 7), new TestDef("AllDifferent/Manifest001.rdf", 7), new TestDef("allValuesFrom/Manifest001.rdf", 3), new TestDef("allValuesFrom/Manifest002.rdf", 7), new TestDef("someValuesFrom/Manifest002.rdf", 7), new TestDef("maxCardinality/Manifest001.rdf", 7), new TestDef("maxCardinality/Manifest002.rdf", 7), new TestDef("FunctionalProperty/Manifest005-mod.rdf", 7), new TestDef("I5.24/Manifest004-mod.rdf", 3), new TestDef("cardinality/Manifest001-mod.rdf", 3), new TestDef("cardinality/Manifest002-mod.rdf", 3), new TestDef("cardinality/Manifest003-mod.rdf", 3), new TestDef("cardinality/Manifest004-mod.rdf", 3), new TestDef("I5.24/Manifest003-mod.rdf", 7), new TestDef("cardinality/Manifest005-mod.rdf", 3), new TestDef("cardinality/Manifest006-mod.rdf", 3), new TestDef("someValuesFrom/Manifest001.rdf", 1), new TestDef("localtests/Manifest003.rdf", 7), new TestDef("localtests/Manifest004.rdf", 3), new TestDef("localtests/Manifest006.rdf", 1), new TestDef("localtests/Manifest007.rdf", 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "consistentData.rdf", 3, null), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent1.rdf", 1, ResourceFactory.createResource("http://jena.hpl.hp.com/testing/reasoners/owl#ia")), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent2.rdf", 1, null), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent3.rdf", 1, null), 3), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent4.rdf", 1, null), 3), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent6.rdf", 1, null), 3), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "inconsistent5.rdf", 1, null), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "emptyClass1.rdf", 2, null), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "emptyClass2.rdf", 2, null), 7), new TestDef((Object)new OWLConsistencyTest("tbox.owl", "emptyClass3.rdf", 2, null), 7)};
    protected String manifest;
    protected ReasonerFactory reasonerFactory;

    public OWLUnitTest(String string, String string2, ReasonerFactory reasonerFactory) {
        super(string2 + ":" + string);
        this.manifest = string;
        this.reasonerFactory = reasonerFactory;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        for (int i = 0; i < reasonerFactories.length; ++i) {
            String string = reasonerNames[i];
            ReasonerFactory reasonerFactory = reasonerFactories[i];
            for (int j = 0; j < testDefs.length; ++j) {
                TestDef testDef = testDefs[j];
                if (!testDef.applicableTo(reasonerFactory)) continue;
                if (testDef.spec instanceof String) {
                    testSuite.addTest((Test)new OWLUnitTest((String)testDef.spec, string, reasonerFactory));
                    continue;
                }
                if (!(testDef.spec instanceof OWLConsistencyTest)) continue;
                OWLConsistencyTest oWLConsistencyTest = (OWLConsistencyTest)((Object)testDef.spec);
                testSuite.addTest((Test)new OWLConsistencyTest(oWLConsistencyTest, string, reasonerFactory));
            }
        }
        return testSuite;
    }

    protected void runTest() throws IOException {
        OWLWGTester oWLWGTester = new OWLWGTester(this.reasonerFactory, this, null);
        oWLWGTester.runTests(this.manifest, false, false);
    }

    static class TestDef {
        public Object spec;
        public int validFor;

        public TestDef(Object object, int n) {
            this.spec = object;
            this.validFor = n;
        }

        public int flagFor(ReasonerFactory reasonerFactory) {
            if (reasonerFactory.equals(OWLFBRuleReasonerFactory.theInstance())) {
                return 1;
            }
            if (reasonerFactory.equals(OWLMiniReasonerFactory.theInstance())) {
                return 2;
            }
            if (reasonerFactory.equals(OWLMicroReasonerFactory.theInstance())) {
                return 4;
            }
            throw new ReasonerException("Unrecognized OWL reasoner config in unit test");
        }

        public boolean applicableTo(ReasonerFactory reasonerFactory) {
            return (this.validFor & this.flagFor(reasonerFactory)) != 0;
        }
    }
}

