/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.cache;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.cache.Cache;

public class EnhancedNodeCache
implements Cache {
    protected String name;
    protected EnhNode[] elements;
    protected boolean enabled = true;
    protected long gets;
    protected long puts;
    protected long hits;

    public EnhancedNodeCache(String string, int n) {
        this.name = string;
        this.elements = new EnhNode[n];
    }

    public Object get(Object object) {
        if (this.enabled) {
            ++this.gets;
            Node node = (Node)object;
            int n = this.hashNode(node);
            EnhNode enhNode = this.elements[n];
            if (enhNode != null && enhNode.asNode().equals(object)) {
                ++this.hits;
                return enhNode;
            }
        }
        return null;
    }

    public void put(Object object, Object object2) {
        if (this.enabled) {
            ++this.puts;
            Node node = (Node)object;
            int n = this.hashNode(node);
            this.elements[n] = (EnhNode)object2;
        }
    }

    protected int hashNode(Node node) {
        return (node.hashCode() & Integer.MAX_VALUE) % this.elements.length;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        return bl2;
    }

    public void clear() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = null;
        }
    }

    public long getGets() {
        return this.gets;
    }

    public long getPuts() {
        return this.puts;
    }

    public long getHits() {
        return this.hits;
    }
}

