/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.serializer.FmtExpr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FormatterARQ;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializer
implements QueryVisitor {
    static final int BLOCK_INDENT = 2;
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;

    QuerySerializer(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        this.out = indentedWriter;
        FormatterARQ formatterARQ = new FormatterARQ(this.out, serializationContext);
        this.fmtTemplate = formatterARQ;
        this.fmtElement = formatterARQ;
        this.fmtExpr = new FmtExprARQ(this.out, serializationContext);
    }

    QuerySerializer(OutputStream outputStream, SerializationContext serializationContext, FormatterTemplate formatterTemplate, FormatterElement formatterElement) {
        this(new IndentedWriter(outputStream), serializationContext, formatterTemplate, formatterElement);
    }

    QuerySerializer(IndentedWriter indentedWriter, SerializationContext serializationContext, FormatterTemplate formatterTemplate, FormatterElement formatterElement) {
        this.out = indentedWriter;
        this.fmtTemplate = formatterTemplate;
        this.fmtElement = formatterElement;
        this.fmtExpr = new FmtExprARQ(this.out, serializationContext);
    }

    public void startVisit(Query query2) {
    }

    public void visitResultForm(Query query2) {
    }

    public void visitBase(Query query2) {
        if (query2.getBaseURI() != null && query2.explicitlySetBaseURI()) {
            this.out.print("BASE    ");
            this.out.print("<" + query2.getBaseURI() + ">");
            this.out.newline();
        }
    }

    public void visitPrefixes(Query query2) {
        Map map = null;
        if (query2.getPrefixMapping() instanceof PrefixMapping2) {
            PrefixMapping2 prefixMapping2 = (PrefixMapping2)query2.getPrefixMapping();
            map = prefixMapping2.getNsPrefixMap(false);
        } else {
            map = query2.getPrefixMapping().getNsPrefixMap();
        }
        if (map.size() > 0) {
            boolean bl = true;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                this.out.print("PREFIX  ");
                this.out.print(string);
                this.out.print(':');
                for (int i = 0; i < 5 - string.length(); ++i) {
                    this.out.print(' ');
                }
                this.out.print(" <" + string2 + ">");
                this.out.newline();
            }
        }
    }

    public void visitSelectResultForm(Query query2) {
        this.out.print("SELECT ");
        if (query2.isDistinct()) {
            this.out.print("DISTINCT ");
        }
        this.out.print(" ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query2, this.out, query2.getResultVars());
        }
        this.out.newline();
    }

    public void visitConstructResultForm(Query query2) {
        this.out.print("CONSTRUCT ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
            this.out.newline();
        } else {
            this.out.incIndent(2);
            this.out.newline();
            TemplateBase templateBase = (TemplateBase)query2.getConstructTemplate();
            templateBase.visit(this.fmtTemplate);
            this.out.decIndent(2);
        }
    }

    public void visitDescribeResultForm(Query query2) {
        this.out.print("DESCRIBE ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query2, this.out, query2.getResultVars());
            QuerySerializer.appendURIList(query2, this.out, query2.getResultURIs());
        }
        this.out.newline();
    }

    public void visitAskResultForm(Query query2) {
        this.out.print("ASK");
        this.out.newline();
    }

    public void visitDatasetDecl(Query query2) {
        String string;
        Iterator iterator;
        if (query2.getGraphURIs() != null && query2.getGraphURIs().size() != 0) {
            this.out.print("FROM  ");
            iterator = query2.getGraphURIs().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.out.print(" ");
                this.out.print(QueryPrintUtils.stringForURI(string, query2.getPrefixMapping()));
            }
            this.out.newline();
        }
        if (query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() != 0) {
            iterator = query2.getNamedGraphURIs().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.out.print("FROM NAMED ");
                this.out.print(QueryPrintUtils.stringForURI(string, query2.getPrefixMapping()));
                this.out.newline();
            }
        }
    }

    public void visitQueryPattern(Query query2) {
        if (query2.getQueryBlock() != null && query2.getQueryBlock().getQueryElement() != null) {
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            query2.getQueryBlock().visit(this.fmtElement);
            this.out.decIndent(2);
            this.out.newline();
        }
    }

    public void visitOrderBy(Query query2) {
        if (query2.hasOrderBy()) {
            this.out.print("ORDER BY ");
            boolean bl = true;
            Iterator iterator = query2.getOrderBy().iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    this.out.print(" ");
                }
                SortCondition sortCondition = (SortCondition)iterator.next();
                sortCondition.format(this.fmtExpr, this.out);
                bl = false;
            }
            this.out.println();
        }
    }

    public void visitLimit(Query query2) {
        if (query2.hasLimit()) {
            this.out.print("LIMIT   " + query2.getLimit());
            this.out.newline();
        }
    }

    public void visitOffset(Query query2) {
        if (query2.hasOffset()) {
            this.out.print("OFFSET  " + query2.getOffset());
            this.out.newline();
        }
    }

    public void finishVisit(Query query2) {
        this.out.flush();
    }

    static void appendVarList(Query query2, IndentedWriter indentedWriter, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!bl) {
                indentedWriter.print(" ");
            }
            indentedWriter.print("?");
            indentedWriter.print(string);
            bl = false;
        }
    }

    static void appendURIList(Query query2, IndentedWriter indentedWriter, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!bl) {
                indentedWriter.print(" ");
            }
            indentedWriter.print(QueryPrintUtils.stringForNode(node, query2.getPrefixMapping()));
            bl = false;
        }
    }
}

