/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.ui.MultiSlotPanel;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListModel;

public class DirectInstancesList
extends SelectableContainer
implements Disposable {
    private Collection _clses = Collections.EMPTY_LIST;
    private SelectableList _list;
    private Project _project;
    private AllowableAction _createAction;
    private AllowableAction _copyAction;
    private AllowableAction _deleteAction;
    private HeaderComponent _header;
    private Collection listenedToInstances = new ArrayList();
    private static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty("ui.DirectInstancesList.sort_limit", 1000);
    private boolean _showSubclassInstances;
    private LabeledComponent _labeledComponent;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directInstanceAdded(ClsEvent clsEvent) {
            Instance instance = clsEvent.getInstance();
            if (!DirectInstancesList.this.getModel().contains(instance)) {
                ComponentUtilities.addListValue(DirectInstancesList.this._list, instance);
                instance.addFrameListener(DirectInstancesList.this._instanceFrameListener);
            }
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            DirectInstancesList.this.removeInstance(clsEvent.getInstance());
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            DirectInstancesList.this.updateButtons();
        }
    };
    private FrameListener _instanceFrameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            super.browserTextChanged(frameEvent);
            DirectInstancesList.this.sort();
            DirectInstancesList.this.repaint();
        }
    };

    public DirectInstancesList(Project project) {
        this._project = project;
        Action action = this.createViewAction();
        this._list = ComponentFactory.createSelectableList(action);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._labeledComponent = new LabeledComponent(null, ComponentFactory.createScrollPane(this._list));
        this.addButtons(action, this._labeledComponent);
        this._labeledComponent.setFooterComponent(new ListFinder((JList)this._list, ResourceKey.INSTANCE_SEARCH_FOR));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)this._labeledComponent, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createHeader(), "North");
        this.add((Component)jPanel, "North");
        this.setSelectable(this._list);
    }

    private void updateLabel() {
        BrowserSlotPattern browserSlotPattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern2 = browserSlotPattern = cls == null ? null : cls.getBrowserSlotPattern();
        String string = browserSlotPattern == null ? null : (browserSlotPattern.isSimple() ? browserSlotPattern.getFirstSlot().getBrowserText() : "multiple slots");
        this._labeledComponent.setHeaderLabel(string);
    }

    private HeaderComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel();
        String string = LocalizedText.getText(ResourceKey.INSTANCE_BROWSER_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this._header = new HeaderComponent(string, string2, jLabel);
        this._header.setColor(Colors.getInstanceColor());
        return this._header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this._list.getCellRenderer();
        frameRenderer.setDisplayType(this._showSubclassInstances);
    }

    protected void addButtons(Action action, LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(action);
        labeledComponent.addHeaderButton(this.createReferencersAction());
        labeledComponent.addHeaderButton(this.createCreateAction());
        labeledComponent.addHeaderButton(this.createCopyAction());
        labeledComponent.addHeaderButton(this.createDeleteAction());
        labeledComponent.addHeaderButton(this.createConfigureAction());
    }

    private void addClsListeners() {
        for (Cls cls : this._clses) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    private void addInstanceListeners() {
        ListModel listModel = this._list.getModel();
        int n = this._list.getFirstVisibleIndex();
        int n2 = this._list.getLastVisibleIndex();
        for (int i = n; i < n2; ++i) {
            Instance instance = (Instance)listModel.getElementAt(i);
            this.addInstanceListener(instance);
        }
    }

    private void removeInstanceListeners() {
        for (Instance instance : this.listenedToInstances) {
            instance.removeFrameListener(this._instanceFrameListener);
        }
        this.listenedToInstances.clear();
    }

    private void addInstanceListener(Instance instance) {
        instance.addFrameListener(this._instanceFrameListener);
        this.listenedToInstances.add(instance);
    }

    protected Action createCreateAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){

            public void onCreate() {
                if (!DirectInstancesList.this._clses.isEmpty()) {
                    Cls cls;
                    KnowledgeBase knowledgeBase = DirectInstancesList.this._project.getKnowledgeBase();
                    Instance instance = knowledgeBase.createInstance(null, DirectInstancesList.this._clses);
                    if (instance instanceof Cls && (cls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        cls.addDirectSuperclass(knowledgeBase.getRootCls());
                    }
                    DirectInstancesList.this._list.setSelectedValue(instance, true);
                }
            }
        };
        return this._createAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu jPopupMenu) {
                jPopupMenu.add(DirectInstancesList.this.createSetDisplaySlotAction());
                jPopupMenu.add(DirectInstancesList.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction abstractAction = new AbstractAction("Show Subclass Instances"){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectInstancesList.this.setShowAllInstances(!DirectInstancesList.this._showSubclassInstances);
            }
        };
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction);
        jCheckBoxMenuItem.setSelected(this._showSubclassInstances);
        return jCheckBoxMenuItem;
    }

    private void setShowAllInstances(boolean bl) {
        this._showSubclassInstances = bl;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this._clses.size() == 1 ? (Cls)CollectionUtilities.getFirstItem(this._clses) : null;
        return cls;
    }

    protected JMenu createSetDisplaySlotAction() {
        JMenu jMenu = ComponentFactory.createMenu("Set Display Slot");
        boolean bl = false;
        Cls cls = this.getSoleAllowedCls();
        if (cls != null) {
            Object object2;
            BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
            Slot slot = browserSlotPattern != null && browserSlotPattern.isSimple() ? browserSlotPattern.getFirstSlot() : null;
            for (Object object2 : cls.getVisibleTemplateSlots()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.createSetDisplaySlotAction((Slot)object2));
                if (object2.equals(slot)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jMenu.add(jRadioButtonMenuItem);
                bl = true;
            }
            object2 = new JRadioButtonMenuItem(this.createSetDisplaySlotMultipleAction());
            if (slot == null) {
                ((AbstractButton)object2).setSelected(true);
            }
            jMenu.add((JMenuItem)object2);
        }
        jMenu.setEnabled(bl);
        return jMenu;
    }

    protected Action createSetDisplaySlotAction(final Slot slot) {
        return new AbstractAction(slot.getBrowserText(), slot.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectInstancesList.this.getSoleAllowedCls().setDirectBrowserSlot(slot);
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Multple Slots..."){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSlotPattern browserSlotPattern;
                Cls cls = DirectInstancesList.this.getSoleAllowedCls();
                BrowserSlotPattern browserSlotPattern2 = DirectInstancesList.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel multiSlotPanel = new MultiSlotPanel(browserSlotPattern2, cls);
                int n = ModalDialog.showDialog(DirectInstancesList.this, multiSlotPanel, "Multislot Display Pattern", 11);
                if (n == 1 && (browserSlotPattern = multiSlotPanel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(browserSlotPattern);
                }
                DirectInstancesList.this.updateLabel();
                DirectInstancesList.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        return this._deleteAction;
    }

    protected Action createCopyAction() {
        this._copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){

            protected Instance copy(Instance instance, boolean bl) {
                Instance instance2 = super.copy(instance, bl);
                DirectInstancesList.this.setSelectedInstance(instance2);
                return instance2;
            }
        };
        return this._copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                DirectInstancesList.this._project.show((Instance)object);
            }
        };
    }

    public void dispose() {
        this.removeClsListeners();
        this.removeInstanceListeners();
    }

    public JComponent getDragComponent() {
        return this._list;
    }

    private SimpleListModel getModel() {
        return (SimpleListModel)this._list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean bl = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void onSelectionChange() {
        boolean bl = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled(this._list, bl);
        this.updateButtons();
    }

    private void removeInstance(Instance instance) {
        ComponentUtilities.removeListValue(this._list, instance);
        instance.removeFrameListener(this._instanceFrameListener);
    }

    private void removeClsListeners() {
        for (Cls cls : this._clses) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection collection) {
        this.removeClsListeners();
        this._clses = new ArrayList(collection);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    public void reload() {
        ArrayList arrayList2;
        this.removeInstanceListeners();
        Object e = this._list.getSelectedValue();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (ArrayList arrayList2 : this._clses) {
            linkedHashSet.addAll(this.getInstances((Cls)((Object)arrayList2)));
        }
        arrayList2 = new ArrayList(linkedHashSet);
        if (arrayList2.size() <= SORT_LIMIT) {
            Collections.sort(arrayList2, new FrameComparator());
        }
        this.getModel().setValues(arrayList2);
        if (arrayList2.contains(e)) {
            this._list.setSelectedValue(e, true);
        } else if (!arrayList2.isEmpty()) {
            this._list.setSelectedIndex(0);
        }
        this.addInstanceListeners();
        this.reloadHeader(this._clses);
        this.updateLabel();
    }

    private void reloadHeader(Collection collection) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Icon icon = null;
        for (Object object2 : collection) {
            if (icon == null) {
                icon = object2.getIcon();
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object2.getName());
        }
        object2 = (JLabel)this._header.getComponent();
        ((JLabel)object2).setText(stringBuffer.toString());
        ((JLabel)object2).setIcon(icon);
    }

    private Collection getInstances(Cls cls) {
        Collection collection = this._showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
        if (!this._project.getDisplayHiddenFrames()) {
            collection = DirectInstancesList.removeHiddenInstances(collection);
        }
        return collection;
    }

    private static Collection removeHiddenInstances(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (instance.isVisible()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void sort() {
        this._list.setListenerNotificationEnabled(false);
        Object e = this._list.getSelectedValue();
        ArrayList arrayList = new ArrayList(this.getModel().getValues());
        if (arrayList.size() <= SORT_LIMIT) {
            Collections.sort(arrayList, new FrameComparator());
        }
        this.getModel().setValues(arrayList);
        this._list.setSelectedValue(e);
        this._list.setListenerNotificationEnabled(true);
    }

    public void setSelectedInstance(Instance instance) {
        this._list.setSelectedValue(instance, true);
        this.updateButtons();
    }

    private void updateButtons() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(this._clses);
        this._createAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean bl = instance != null && instance instanceof SimpleInstance;
        this._copyAction.setAllowed(bl);
    }

    public void setShowDisplaySlotPanel(boolean bl) {
    }
}

