/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DirectInstancesList;
import edu.stanford.smi.protege.ui.DirectTypesList;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.InstanceClsesPanel;
import edu.stanford.smi.protege.widget.InstanceClsesTreeTarget;
import edu.stanford.smi.protege.widget.InstancesTabDirectInstancesListDragSourceListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class InstancesTab
extends AbstractTabWidget {
    private InstanceDisplay _instanceDisplay;
    private InstanceClsesPanel _clsesPanel;
    private DirectInstancesList _directInstancesList;
    private DirectTypesList _directTypesList;

    private JComponent createClsesPanel() {
        this._clsesPanel = new InstanceClsesPanel(this.getProject());
        this._clsesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                InstancesTab.this.transmitSelection();
            }
        });
        return this._clsesPanel;
    }

    private JComponent createClsSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("InstancesTab.left_right", 250);
        jSplitPane.setLeftComponent(this.createClsesPanel());
        jSplitPane.setRightComponent(this.createInstanceSplitter());
        return jSplitPane;
    }

    protected JComponent createDirectInstancesList() {
        this._directInstancesList = new DirectInstancesList(this.getProject());
        this._directInstancesList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = InstancesTab.this._directInstancesList.getSelection();
                Instance instance = collection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem(collection) : null;
                InstancesTab.this._instanceDisplay.setInstance(instance);
                InstancesTab.this._directTypesList.setInstance(instance);
            }
        });
        this.setInstanceSelectable((Selectable)((Object)this._directInstancesList.getDragComponent()));
        return this._directInstancesList;
    }

    protected JComponent createDirectTypesList() {
        this._directTypesList = new DirectTypesList(this.getProject());
        return this._directTypesList;
    }

    protected JComponent createInstanceDisplay() {
        return new InstanceDisplay(this.getProject());
    }

    private JComponent createInstancesPanel() {
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane();
        jSplitPane.setTopComponent(this.createDirectInstancesList());
        jSplitPane.setBottomComponent(this.createDirectTypesList());
        return jSplitPane;
    }

    private JComponent createInstanceSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("InstancesTab.right.left_right", 250);
        jSplitPane.setLeftComponent(this.createInstancesPanel());
        this._instanceDisplay = (InstanceDisplay)this.createInstanceDisplay();
        jSplitPane.setRightComponent(this._instanceDisplay);
        return jSplitPane;
    }

    public LabeledComponent getLabeledComponent() {
        return this._clsesPanel.getLabeledComponent();
    }

    public void initialize() {
        this.setIcon(Icons.getInstanceIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.INSTANCES_VIEW_TITLE));
        this.add(this.createClsSplitter());
        this.transmitSelection();
        this.setupDragAndDrop();
        this.setClsTree(this._clsesPanel.getDropComponent());
    }

    public void setSelectedCls(Cls cls) {
        this._clsesPanel.setSelectedCls(cls);
    }

    public void setSelectedInstance(Instance instance) {
        this._clsesPanel.setSelectedCls(instance.getDirectType());
        this._directInstancesList.setSelectedInstance(instance);
        this._directTypesList.setInstance(instance);
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this._directInstancesList.getDragComponent(), 3, new InstancesTabDirectInstancesListDragSourceListener());
        new DropTarget(this._clsesPanel.getDropComponent(), 3, new InstanceClsesTreeTarget());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitSelection() {
        WaitCursor waitCursor = new WaitCursor(this);
        try {
            Collection collection = this._clsesPanel.getSelection();
            this.transmitSelection(collection);
        }
        finally {
            waitCursor.hide();
        }
    }

    protected void transmitSelection(Collection collection) {
        this._directInstancesList.setClses(collection);
    }
}

