/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;

public abstract class TextComponentWidget
extends AbstractSlotWidget {
    private static final Color INVALID_COLOR = Color.red;
    private JTextComponent _textComponent;
    private Color _defaultColor;
    private boolean _isDirty;
    private DocumentChangedListener _documentListener = new DocumentChangedListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            TextComponentWidget.this.onTextChange();
        }
    };
    private FocusListener _focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            TextComponentWidget.this.commitChanges();
        }
    };
    private KeyListener _keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                TextComponentWidget.this.commitChanges();
            }
        }
    };

    public void commitChanges() {
        this.onCommit();
        if (this._isDirty) {
            this.valueChanged();
        }
    }

    protected void onCommit() {
    }

    protected Collection createActions() {
        return Collections.EMPTY_LIST;
    }

    private void onTextChange() {
        this.validateText(this.getText());
        this._isDirty = true;
    }

    protected abstract JTextComponent createTextComponent();

    protected abstract JComponent createCenterComponent(JTextComponent var1);

    public void dispose() {
        this.commitChanges();
        super.dispose();
    }

    protected String getInvalidTextDescription(String string) {
        return null;
    }

    public String getText() {
        String string = this._textComponent.getText().trim();
        return string.length() == 0 ? null : string;
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public void markDirty(boolean bl) {
        this._isDirty = bl;
    }

    public void setInstanceValues() {
        super.setInstanceValues();
        this._isDirty = false;
    }

    public Collection getValues() {
        String string = this.getText();
        return CollectionUtilities.createList(string);
    }

    public void initialize(boolean bl, int n, int n2) {
        this._textComponent = this.createTextComponent();
        this._textComponent.getDocument().addDocumentListener(this._documentListener);
        this._textComponent.addFocusListener(this._focusListener);
        this._textComponent.addKeyListener(this._keyListener);
        this._defaultColor = this._textComponent.getForeground();
        JComponent jComponent = this.createCenterComponent(this._textComponent);
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), jComponent, bl);
        for (Action action : this.createActions()) {
            labeledComponent.addHeaderButton(action);
        }
        this.add(labeledComponent);
        this.setPreferredColumns(n);
        this.setPreferredRows(n2);
    }

    public boolean isEditable() {
        return this._textComponent.isEditable();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            boolean bl2 = valueType == ValueType.STRING;
            boolean bl3 = valueType == ValueType.SYMBOL;
            boolean bl4 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = (bl2 || bl3) && !bl4;
        }
        return bl;
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextComponentWidget.this._textComponent.selectAll();
                TextComponentWidget.this._textComponent.requestFocus();
            }
        });
    }

    public void setEditable(boolean bl) {
        this._textComponent.setEditable(bl);
    }

    public void setText(String string) {
        this._documentListener.disable();
        this._textComponent.setText(string == null ? "" : string);
        this.onSetText(string);
        this._documentListener.enable();
        this.validateText(string);
    }

    protected void onSetText(String string) {
    }

    public void setInstance(Instance instance) {
        if (this._isDirty) {
            this.valueChanged();
        }
        super.setInstance(instance);
    }

    public void setValues(Collection collection) {
        Object object = CollectionUtilities.getFirstItem(collection);
        String string = object == null ? (String)null : object.toString();
        this.setText(string);
    }

    protected boolean validateText(String string) {
        String string2;
        String string3 = string2 = string == null ? null : this.getInvalidTextDescription(string);
        if (string2 == null) {
            this._textComponent.setForeground(this._defaultColor);
            this._textComponent.setToolTipText(null);
        } else {
            this._textComponent.setForeground(INVALID_COLOR);
            this._textComponent.setToolTipText(string2);
        }
        return string2 == null;
    }
}

