/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.reasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGErrorException;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerPreferences;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLogger;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultDIGReasoner
implements DIGReasoner {
    private URL reasonerURL;
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    private XMLSerializer serializer;
    private OutputFormat format;
    private DIGTranslator translator = DIGTranslatorFactory.getInstance().createTranslator();
    public static boolean log = true;

    public DefaultDIGReasoner() {
        try {
            this.reasonerURL = new URL("http://localhost:8080");
        }
        catch (MalformedURLException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        this.format = new OutputFormat();
        this.format.setIndent(4);
        this.format.setIndenting(true);
        this.format.setPreserveSpace(false);
        this.serializer = new XMLSerializer(this.format);
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void setReasonerURL(String url) {
        try {
            this.reasonerURL = new URL(url);
        }
        catch (MalformedURLException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public String getReasonerURL() {
        return this.reasonerURL.toString();
    }

    public DIGReasonerIdentity getIdentity() throws DIGReasonerException {
        Document request = this.translator.createDIGDocument("getIdentifier");
        Document response = this.performRequest(request);
        DIGReasonerIdentity id = new DIGReasonerIdentity();
        id.parseIdentityDescrtiption(response);
        return id;
    }

    public String createKnowledgeBase() throws DIGReasonerException {
        Document request = this.translator.createDIGDocument("newKB");
        Document doc = this.performRequest(request);
        Element kbElement = (Element)doc.getDocumentElement().getElementsByTagName("kb").item(0);
        return kbElement.getAttribute("uri");
    }

    public void releaseKnowledgeBase(String kbURI) throws DIGReasonerException {
        Document doc = this.translator.createDIGDocument("releaseKB");
        doc.getDocumentElement().setAttribute("uri", kbURI);
        this.performRequest(doc);
    }

    public void clearKnowledgeBase(String kbURI) throws DIGReasonerException {
        Document doc = this.translator.createDIGDocument("tells", kbURI);
        Element element = doc.createElement("clearKB");
        doc.getDocumentElement().appendChild(element);
        this.performRequest(doc);
    }

    public Document performRequest(Document request) throws DIGReasonerException {
        if (DIGReasonerPreferences.getInstance().isLogDIG()) {
            this.log(request);
        }
        try {
            StringWriter writer = new StringWriter();
            this.serializer.setOutputCharStream((Writer)writer);
            this.serializer.serialize(request);
            HttpURLConnection conn = (HttpURLConnection)this.reasonerURL.openConnection();
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            StringBuffer buffer = writer.getBuffer();
            conn.setRequestProperty("Content-Length", "" + buffer.length());
            conn.connect();
            OutputStream os = conn.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(buffer.toString());
            osw.flush();
            osw.close();
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            Document doc = this.docBuilder.parse(new InputSource(reader));
            ((Reader)reader).close();
            conn.disconnect();
            if (DIGReasonerPreferences.getInstance().isLogDIG()) {
                this.log(doc);
            }
            this.performErrorCheck(doc);
            return doc;
        }
        catch (IOException e) {
            throw new DIGReasonerException(e.getMessage(), e);
        }
        catch (SAXException saxEx) {
            throw new DIGReasonerException(saxEx.getMessage(), saxEx);
        }
    }

    protected void performErrorCheck(Document doc) throws DIGErrorException {
        NodeList errors = doc.getDocumentElement().getElementsByTagName("error");
        if (errors.getLength() > 0) {
            ArrayList<DIGError> errorList = new ArrayList<DIGError>(errors.getLength());
            int i = 0;
            while (i < errors.getLength()) {
                Element element = (Element)errors.item(i);
                String message = String.valueOf(element.getAttribute("message")) + " [ID: " + element.getAttribute("id") + "]";
                String code = ((Element)errors.item(i)).getAttribute("code");
                DIGError error = new DIGError(element.getAttribute("id"), message, code);
                errorList.add(error);
                ++i;
            }
            if (!DIGReasonerPreferences.getInstance().isTreatErrorsAsWarnings()) {
                throw new DIGErrorException(errorList);
            }
            DIGLogger logger = DIGLogger.getInstance(this);
            Iterator it = errorList.iterator();
            while (it.hasNext()) {
                logger.logError((DIGError)it.next());
            }
        }
    }

    protected void log(Document doc) {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        format.setIndent(4);
        format.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(DIGReasonerPreferences.getInstance().getLogOutputStream(), format);
        try {
            serializer.serialize(doc);
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        Logger.getLogger("edu.stanford.smi.protegex.owl.inference.dig.reasoner").info(writer.getBuffer().toString());
    }

    public DIGTranslator getTranslator() {
        return this.translator;
    }
}

