/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ClosureAxiomFactoryTestCase
extends AbstractJenaTestCase {
    public void testAddClosureAxiomToPrimitiveClass() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass fatherClass = this.owlModel.createOWLNamedClass("Father");
        OWLNamedClass motherClass = this.owlModel.createOWLNamedClass("Mother");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom fatherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherClass);
        OWLSomeValuesFrom motherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, motherClass);
        personClass.addSuperclass(fatherRestriction);
        personClass.addSuperclass(motherRestriction);
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(personClass, fatherRestriction));
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(personClass, motherRestriction));
        OWLAllValuesFrom closure = ClosureAxiomFactory.addClosureAxiom(personClass, fatherRestriction);
        ClosureAxiomFactoryTestCase.assertEquals((int)4, (int)personClass.getSuperclassCount());
        ClosureAxiomFactoryTestCase.assertContains((Object)closure, personClass.getPureSuperclasses());
        ClosureAxiomFactoryTestCase.assertEquals((Object)property, (Object)closure.getOnProperty());
        OWLUnionClass filler = (OWLUnionClass)closure.getFiller();
        ClosureAxiomFactoryTestCase.assertContains((Object)fatherClass, filler.getOperands());
        ClosureAxiomFactoryTestCase.assertContains((Object)motherClass, filler.getOperands());
        ClosureAxiomFactoryTestCase.assertSize(2, filler.getOperands());
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(personClass, fatherRestriction));
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(personClass, motherRestriction));
    }

    public void testAddClosureAxiomToSimpleDefinedClass() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass fatherClass = this.owlModel.createOWLNamedClass("Father");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherClass);
        personClass.setDefinition(restriction);
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(personClass, restriction));
        OWLAllValuesFrom closure = ClosureAxiomFactory.addClosureAxiom(personClass, restriction);
        ClosureAxiomFactoryTestCase.assertEquals((int)2, (int)personClass.getSuperclassCount());
        OWLIntersectionClass newIntersectionClass = (OWLIntersectionClass)personClass.getDefinition();
        ClosureAxiomFactoryTestCase.assertEquals((String)"(hasParent some Father) and (hasParent only Father)", (String)newIntersectionClass.getBrowserText());
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(personClass, restriction));
    }

    public void testAddClosureAxiomToComplexDefinedClass() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass fatherClass = this.owlModel.createOWLNamedClass("Father");
        OWLNamedClass motherClass = this.owlModel.createOWLNamedClass("Mother");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasParent");
        OWLSomeValuesFrom fatherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fatherClass);
        OWLSomeValuesFrom motherRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, motherClass);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(fatherRestriction);
        intersectionCls.addOperand(motherRestriction);
        personClass.setDefinition(intersectionCls);
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(personClass, fatherRestriction));
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(personClass, motherRestriction));
        OWLAllValuesFrom closure = ClosureAxiomFactory.addClosureAxiom(personClass, fatherRestriction);
        ClosureAxiomFactoryTestCase.assertEquals((int)2, (int)personClass.getSuperclassCount());
        OWLIntersectionClass newIntersectionClass = (OWLIntersectionClass)personClass.getDefinition();
        ClosureAxiomFactoryTestCase.assertEquals((String)"(hasParent some Father) and (hasParent some Mother) and (hasParent only (Father or Mother))", (String)newIntersectionClass.getBrowserText());
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(personClass, fatherRestriction));
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(personClass, motherRestriction));
    }

    public void testAddClosureAxiomForOWLHasValue() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLIndividual filler = this.owlThing.createOWLIndividual("Individual");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLHasValue restriction = this.owlModel.createOWLHasValue(property, filler);
        namedClass.addSuperclass(restriction);
        ClosureAxiomFactoryTestCase.assertNull((Object)ClosureAxiomFactory.getClosureAxiom(namedClass, restriction));
        OWLAllValuesFrom closure = ClosureAxiomFactory.addClosureAxiom(namedClass, restriction);
        ClosureAxiomFactoryTestCase.assertTrue((boolean)(closure.getAllValuesFrom() instanceof OWLEnumeratedClass));
        OWLEnumeratedClass enumClass = (OWLEnumeratedClass)closure.getAllValuesFrom();
        ClosureAxiomFactoryTestCase.assertSize(1, enumClass.getOneOf());
        ClosureAxiomFactoryTestCase.assertContains((Object)filler, enumClass.getOneOf());
        ClosureAxiomFactoryTestCase.assertEquals((Object)closure, (Object)ClosureAxiomFactory.getClosureAxiom(namedClass, restriction));
    }
}

