/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.SWRLRuleEngineGUIAdapter;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SWRLRuleEngineManager {
    private static HashMap registeredRuleEngines = new HashMap();
    private static String visibleRuleEngineName = "";
    private static ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent event) {
            Project project = (Project)event.getSource();
            project.removeProjectListener(projectListener);
            visibleRuleEngineName = "";
        }
    };

    static {
        try {
            Class.forName("edu.stanford.smi.protegex.owl.swrl.bridge.jess.ui.SWRLJessTab");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find the edu.stanford.smi.protegex.owl.swrl.bridge.jess.ui.SWRLJessTab class");
        }
    }

    public static void registerRuleEngine(String ruleEngineName, String toolTip, Icon icon, SWRLRuleEngineGUIAdapter guiAdapter) {
        if (registeredRuleEngines.containsKey(ruleEngineName)) {
            registeredRuleEngines.remove(ruleEngineName);
        }
        registeredRuleEngines.put(ruleEngineName, new RuleEngineRegistrationInfo(ruleEngineName, toolTip, icon, guiAdapter));
        System.err.println("Registering " + ruleEngineName + " rule engine with SWRL bridge.");
    }

    public static Collection getRegisteredRuleEngines() {
        return registeredRuleEngines.values();
    }

    public static void unregisterEngine(String ruleEngineName) {
        if (registeredRuleEngines.containsKey(ruleEngineName)) {
            if (SWRLRuleEngineManager.isVisible(ruleEngineName)) {
                SWRLRuleEngineManager.hideRuleEngine(ruleEngineName, true);
            }
            registeredRuleEngines.remove(ruleEngineName);
        }
    }

    public static boolean isVisible(String ruleEngineName) {
        return !visibleRuleEngineName.equals("") && ruleEngineName.equals(visibleRuleEngineName);
    }

    public static void showRuleEngine(String ruleEngineName, SWRLTab swrlTab, OWLModel owlModel) {
        owlModel.getProject().addProjectListener(projectListener);
        if (!SWRLRuleEngineManager.isVisible(ruleEngineName) && SWRLRuleEngineManager.hideRuleEngine(visibleRuleEngineName) && registeredRuleEngines.containsKey(ruleEngineName)) {
            RuleEngineRegistrationInfo info = (RuleEngineRegistrationInfo)registeredRuleEngines.get(ruleEngineName);
            Container ruleEngineGUI = info.getGUIAdapter().createRuleEngineGUI(owlModel);
            if (ruleEngineGUI != null) {
                swrlTab.add(ruleEngineGUI);
                swrlTab.setVisible(false);
                swrlTab.setVisible(true);
                visibleRuleEngineName = ruleEngineName;
            } else {
                SWRLRuleEngineManager.makeTextPanel(swrlTab, "Unable to activate the " + ruleEngineName + " rule engine.");
            }
        }
    }

    public static void hideVisibleRuleEngine() {
        SWRLRuleEngineManager.hideRuleEngine(visibleRuleEngineName, true);
    }

    public static boolean hideRuleEngine(String ruleEngineName) {
        return SWRLRuleEngineManager.hideRuleEngine(ruleEngineName, false);
    }

    private static boolean hideRuleEngine(String ruleEngineName, boolean force) {
        if (SWRLRuleEngineManager.isVisible(ruleEngineName)) {
            if (!force && JOptionPane.showConfirmDialog(null, "Do you really want to disable the " + ruleEngineName + " rule engine?", "Disable " + ruleEngineName, 0) != 0) {
                return false;
            }
            if (registeredRuleEngines.containsKey(ruleEngineName)) {
                RuleEngineRegistrationInfo info = (RuleEngineRegistrationInfo)registeredRuleEngines.get(ruleEngineName);
                Container ruleEngineGUI = info.getGUIAdapter().getRuleEngineGUI();
                Container swrlTab = ruleEngineGUI.getParent();
                swrlTab.remove(ruleEngineGUI);
                swrlTab.setVisible(false);
                swrlTab.setVisible(true);
                visibleRuleEngineName = "";
            }
        }
        return true;
    }

    private static void makeTextPanel(SWRLTab swrlTab, String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        swrlTab.add(panel);
    }

    public static class RuleEngineRegistrationInfo {
        private String ruleEngineName;
        private String toolTip;
        private SWRLRuleEngineGUIAdapter guiAdapter;
        private Icon icon;

        public RuleEngineRegistrationInfo(String ruleEngineName, String toolTip, Icon icon, SWRLRuleEngineGUIAdapter guiAdapter) {
            this.ruleEngineName = ruleEngineName;
            this.toolTip = toolTip;
            this.guiAdapter = guiAdapter;
            this.icon = icon;
        }

        public String getRuleEngineName() {
            return this.ruleEngineName;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public SWRLRuleEngineGUIAdapter getGUIAdapter() {
            return this.guiAdapter;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

