/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.owldl;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoCardiRestrictionOnTransitivePropertiesOWLDLTest
extends AbstractOWLTest
implements OWLDLTest,
RDFSClassTest {
    public NoCardiRestrictionOnTransitivePropertiesOWLDLTest() {
        super("OWL-DL Tests", null);
    }

    public static boolean fails(RDFSClass aClass) {
        if (aClass instanceof OWLCardinalityBase) {
            OWLCardinalityBase r = (OWLCardinalityBase)aClass;
            RDFProperty slot = r.getOnProperty();
            return NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(slot, new HashSet());
        }
        return false;
    }

    private static boolean isTransitive(Slot slot, Set reached) {
        if (!reached.contains(slot)) {
            reached.add(slot);
            if (slot instanceof OWLObjectProperty) {
                OWLObjectProperty objectSlot = (OWLObjectProperty)slot;
                if (objectSlot.isTransitive()) {
                    return true;
                }
                for (Slot subSlot : slot.getDirectSubslots()) {
                    if (!NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(subSlot, reached)) continue;
                    return true;
                }
                Slot inverseSlot = slot.getInverseSlot();
                if (inverseSlot != null && NoCardiRestrictionOnTransitivePropertiesOWLDLTest.isTransitive(inverseSlot, reached)) {
                    return true;
                }
            }
        }
        return false;
    }

    public List test(RDFSClass aClass) {
        if (NoCardiRestrictionOnTransitivePropertiesOWLDLTest.fails(aClass)) {
            return Collections.singletonList(new DefaultOWLTestResult("Cardinality restrictions on transitive properties (or inverse or super properties of them) are not allowed in OWL DL.", aClass, 3, this));
        }
        return Collections.EMPTY_LIST;
    }
}

