/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JCalendar;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import java.awt.Component;
import java.util.Date;

public class DateValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource instance, RDFProperty property, Object value) {
        RDFSDatatype date = instance.getOWLModel().getXSDdate();
        return DateValueEditor.canEdit(date, instance, property, value);
    }

    static boolean canEdit(RDFSDatatype dataType, RDFResource instance, RDFProperty property, Object value) {
        RDFSLiteral literal;
        if (value instanceof RDFSLiteral && dataType.equals((literal = (RDFSLiteral)value).getDatatype())) {
            return true;
        }
        for (RDFSClass type : instance.getRDFTypes()) {
            if (!(type instanceof RDFSNamedClass) || !OWLWidgetUtil.isDatatypeProperty(dataType, (RDFSNamedClass)type, property)) continue;
            return true;
        }
        return false;
    }

    public Object createDefaultValue(RDFResource instance, RDFProperty property) {
        String str = XMLSchemaDatatypes.getDefaultDateValue();
        return this.createRDFSLiteral(property.getOWLModel(), str);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel owlModel, String str) {
        return owlModel.createRDFSLiteral(str, owlModel.getRDFSDatatypeByURI(XSDDatatype.XSDdate.getURI()));
    }

    public Object editValue(Component parent, RDFResource instance, RDFProperty property, Object value) {
        if (this.canEdit(instance, property, value)) {
            JCalendar calendar = new JCalendar(OWLDateWidget.getDate(value.toString()));
            String name = property.getBrowserText();
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            LabeledComponent lc = new LabeledComponent(name, (Component)calendar);
            int r = ProtegeUI.getModalDialogFactory().showDialog(parent, (Component)lc, "Edit " + property.getBrowserText(), 11);
            if (r == 1) {
                Date date = calendar.getDate();
                String newValue = XMLSchemaDatatypes.getDateString(date);
                return this.createRDFSLiteral(property.getOWLModel(), newValue);
            }
        }
        return null;
    }

    public boolean mustEdit(RDFResource subject, RDFProperty predicate, Object value) {
        return this.canEdit(subject, predicate, value);
    }
}

