/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.property;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;

public class PropertyMatrixAction
extends AbstractAction {
    private OWLModel owlModel;

    public PropertyMatrixAction(OWLModel owlModel) {
        super("Show properties list", OWLIcons.getImageIcon("PropertyMatrix"));
        this.owlModel = owlModel;
    }

    public void actionPerformed(ActionEvent e) {
        MatrixFilter filter = new MatrixFilter(){

            public Collection getInitialValues() {
                Collection properties = PropertyMatrixAction.this.owlModel.getVisibleUserDefinedRDFProperties();
                Iterator it = properties.iterator();
                while (it.hasNext()) {
                    RDFResource slot = (RDFResource)it.next();
                    if (this.isSuitable(slot)) continue;
                    it.remove();
                }
                return properties;
            }

            public String getName() {
                return "All Properties";
            }

            public boolean isSuitable(RDFResource instance) {
                return instance instanceof RDFProperty && instance.isVisible() && (instance.isEditable() || instance.isIncluded());
            }
        };
        MatrixPanel panel = new MatrixPanel(this.owlModel, filter, new PropertyMatrixTableModel(this.owlModel, filter));
        ResultsPanelManager.addResultsPanel(this.owlModel, panel, true);
    }
}

