/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class RemovePropertyWidgetFromFormAction
extends ResourceSelectionAction {
    private RDFResource resource;
    private ResourceDisplay parent;

    public RemovePropertyWidgetFromFormAction(RDFResource resource, ResourceDisplay parent) {
        super("Remove property widget from form...", OWLIcons.getImageIcon("RemovePropertyWidgetFromForm"));
        this.resource = resource;
        this.parent = parent;
    }

    public void resourceSelected(RDFResource resource) {
        RDFSClass directType = this.resource.getProtegeType();
        Project project = this.resource.getProject();
        FormWidget formWidget = (FormWidget)project.getDesignTimeClsWidget((Cls)directType);
        Slot slot = (Slot)resource;
        formWidget.replaceWidget(slot, null);
        this.parent.setInstance(null);
        this.parent.setInstance(this.resource);
    }

    public Collection getSelectableResources() {
        RDFSClass directType = this.resource.getProtegeType();
        FormWidget formWidget = (FormWidget)this.resource.getProject().getDesignTimeClsWidget((Cls)directType);
        ArrayList properties = new ArrayList(directType.getUnionDomainProperties(true));
        for (RDFProperty property : directType.getUnionDomainProperties(true)) {
            if (!property.isSystem() && property instanceof OWLProperty && !((OWLProperty)property).isAnnotationProperty() && formWidget.getSlotWidget((Slot)property) != null) continue;
            properties.remove(property);
        }
        return properties;
    }

    public RDFResource pickResource() {
        String label = "Select a property to remove the widget for";
        OWLModel owlModel = this.resource.getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectProperty((Component)((Object)this.parent), owlModel, this.getSelectableResources(), label);
    }
}

