/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractOWLModelTestCase;
import java.util.ArrayList;
import java.util.Collection;

public class CompactOWLClassParserTestCase
extends AbstractOWLModelTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseComplementClass() throws Exception {
        this.owlModel.createOWLNamedClass("Person");
        String expression = "!Person";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        CompactOWLClassParserTestCase.assertTrue((boolean)(aClass instanceof OWLComplementClass));
        OWLComplementClass complementCls = (OWLComplementClass)aClass;
        RDFSClass complement = complementCls.getComplement();
        CompactOWLClassParserTestCase.assertTrue((boolean)(complement instanceof OWLNamedClass));
        CompactOWLClassParserTestCase.assertEquals((Object)complement, (Object)this.owlModel.getRDFSNamedClass("Person"));
    }

    public void testParseIntersection() throws Exception {
        OWLNamedClass richPerson = this.owlModel.createOWLNamedClass("RichPerson");
        OWLNamedClass parent = this.owlModel.createOWLNamedClass("Parent");
        String expression = "RichPerson & Parent";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        CompactOWLClassParserTestCase.assertTrue((boolean)(aClass instanceof OWLIntersectionClass));
        OWLIntersectionClass intersectionCls = (OWLIntersectionClass)aClass;
        Collection clses = intersectionCls.getOperands();
        CompactOWLClassParserTestCase.assertEquals((int)clses.size(), (int)2);
        CompactOWLClassParserTestCase.assertTrue((boolean)clses.contains(richPerson));
        CompactOWLClassParserTestCase.assertTrue((boolean)clses.contains(parent));
    }

    public void testParseLongIntersection() throws Exception {
        this.owlModel.createOWLNamedClass("RichPerson");
        this.owlModel.createOWLNamedClass("Parent");
        this.owlModel.createOWLObjectProperty("children");
        String expression = "RichPerson & Parent & (children * RichPerson)";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        CompactOWLClassParserTestCase.assertTrue((boolean)(aClass instanceof OWLIntersectionClass));
        OWLIntersectionClass intersectionCls = (OWLIntersectionClass)aClass;
        ArrayList clses = new ArrayList(intersectionCls.getOperands());
        CompactOWLClassParserTestCase.assertEquals((int)clses.size(), (int)3);
        clses.remove(this.owlModel.getRDFSNamedClass("RichPerson"));
        clses.remove(this.owlModel.getRDFSNamedClass("Parent"));
        CompactOWLClassParserTestCase.assertEquals((int)clses.size(), (int)1);
        Cls all = (Cls)clses.iterator().next();
        CompactOWLClassParserTestCase.assertTrue((boolean)(all instanceof OWLAllValuesFrom));
    }

    public void testParseNamedClass() throws Exception {
        this.owlModel.createOWLNamedClass("Person");
        String expression = "Person";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        CompactOWLClassParserTestCase.assertTrue((boolean)(aClass instanceof OWLNamedClass));
    }

    public void testParseUnion() throws Exception {
        this.owlModel.createOWLNamedClass("RichPerson");
        this.owlModel.createOWLNamedClass("Parent");
        String expression = "RichPerson | Parent";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        CompactOWLClassParserTestCase.assertTrue((boolean)(aClass instanceof OWLUnionClass));
        OWLUnionClass unionCls = (OWLUnionClass)aClass;
        Collection clses = unionCls.getOperands();
        CompactOWLClassParserTestCase.assertEquals((int)clses.size(), (int)2);
        CompactOWLClassParserTestCase.assertTrue((boolean)clses.contains(this.owlModel.getRDFSNamedClass("RichPerson")));
        CompactOWLClassParserTestCase.assertTrue((boolean)clses.contains(this.owlModel.getRDFSNamedClass("Parent")));
    }
}

