/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class DefaultOWLOntology
extends DefaultRDFIndividual
implements OWLOntology {
    public DefaultOWLOntology(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLOntology() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLOntology(this);
    }

    public void addBackwardCompatibleWith(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        this.addOwnSlotValue(slot, resource);
    }

    public void addImports(String uri) {
        TripleStore ts = this.getOWLModel().getTripleStoreModel().getTripleStore(uri);
        if (ts != null) {
            OWLOntology ont = (OWLOntology)TripleStoreUtil.getFirstOntology(this.getOWLModel(), ts);
            this.addImportsHelper(ont);
        } else {
            RDFUntypedResource resource = this.getOWLModel().getRDFUntypedResource(uri, true);
            this.addImportsHelper(resource);
        }
    }

    public void addImports(URI uri) {
        this.addImports(uri.toString());
    }

    public void addImports(RDFExternalResource resource) {
        this.addImportsHelper(resource);
    }

    public void addImports(RDFUntypedResource resource) {
        this.addImportsHelper(resource);
    }

    public void addImports(OWLOntology ontology) {
        this.addImportsHelper(ontology);
    }

    private void addImportsHelper(Object resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        this.addOwnSlotValue(slot, resource);
    }

    public void addIncompatibleWith(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        this.addOwnSlotValue(slot, resource);
    }

    public void addPriorVersion(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        this.addOwnSlotValue(slot, resource);
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof OWLOntology) {
            OWLOntology ontology = (OWLOntology)object;
            return this.getURI().equals(ontology.getURI());
        }
        return false;
    }

    public Collection getBackwardCompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        return this.getOwnSlotValues(slot);
    }

    public String getBrowserText() {
        String uri = this.getOntologyURI();
        if (uri == null) {
            return "DefaultOntology";
        }
        return "Ontology(" + uri + ")";
    }

    public Icon getIcon() {
        Icon icon = OWLIcons.getImageIcon("OWLOntology");
        if (!this.isAssociatedTriplestoreEditable() || !this.isActive()) {
            icon = OWLIcons.getReadOnlyIcon(icon, "RDFIndividualFrame");
        }
        return icon;
    }

    public Collection getImports() {
        Collection resources = this.getImportResources();
        ArrayList<String> results = new ArrayList<String>();
        for (Object o : resources) {
            results.add(((RDFResource)o).getURI());
        }
        return results;
    }

    public Collection getImportResources() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        return this.getOwnSlotValues(slot);
    }

    public Collection getIncompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        return this.getOwnSlotValues(slot);
    }

    public String getOntologyURI() {
        return this.getURI();
    }

    public Collection getPriorVersions() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        return this.getOwnSlotValues(slot);
    }

    public void removeBackwardCompatibleWith(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        this.removeOwnSlotValue(slot, resource);
    }

    public void removeImports(String uri) {
        Object removeValue = null;
        Collection values = this.getImportResources();
        for (Object o : values) {
            String otherURI = ((RDFResource)o).getURI();
            if (!otherURI.equals(uri)) continue;
            removeValue = o;
            break;
        }
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        this.removeOwnSlotValue(slot, removeValue);
    }

    public void removeIncompatibleWith(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        this.removeOwnSlotValue(slot, resource);
    }

    public void removePriorVersion(String resource) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        this.removeOwnSlotValue(slot, resource);
    }

    public boolean isAssociatedTriplestoreEditable() {
        TripleStore top;
        boolean result = false;
        OWLModel owlModel = this.getOWLModel();
        if (this == TripleStoreUtil.getFirstOntology(owlModel, top = owlModel.getTripleStoreModel().getTopTripleStore())) {
            result = true;
        } else {
            RepositoryManager man = owlModel.getRepositoryManager();
            URI ontURI = null;
            try {
                ontURI = new URI(this.getURI());
                Repository rep = man.getRepository(ontURI);
                if (rep != null) {
                    result = rep.isWritable(ontURI);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean isActive() {
        TripleStore active = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        return this == TripleStoreUtil.getFirstOntology(this.getOWLModel(), active);
    }
}

