/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import java.util.Collections;

public class DefaultRDFSDatatypeFactory
implements RDFSDatatypeFactory {
    private OWLModel owlModel;

    public DefaultRDFSDatatypeFactory(OWLModel owlModel) {
        this.owlModel = owlModel;
    }

    public RDFSDatatype createAnonymousDatatype(RDFSDatatype baseType) {
        String name = this.owlModel.getNextAnonymousResourceName();
        return this.createDatatype(baseType, name);
    }

    public RDFSDatatype createDatatype(RDFSDatatype baseType, String name) {
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype(name);
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 0);
        datatype.setPropertyValue(property, baseType);
        return datatype;
    }

    public void setLength(RDFSDatatype datatype, int value) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 2);
        if (value >= 0) {
            datatype.setPropertyValue(property, new Integer(value));
        } else {
            datatype.setPropertyValues(property, Collections.EMPTY_LIST);
        }
    }

    public void setMaxExclusive(RDFSDatatype datatype, RDFSLiteral literal) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 5);
        datatype.setPropertyValue(property, literal);
    }

    public void setMaxInclusive(RDFSDatatype datatype, RDFSLiteral literal) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 6);
        datatype.setPropertyValue(property, literal);
    }

    public void setMaxLength(RDFSDatatype datatype, int value) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 8);
        if (value >= 0) {
            datatype.setPropertyValue(property, new Integer(value));
        } else {
            datatype.setPropertyValues(property, Collections.EMPTY_LIST);
        }
    }

    public void setMinExclusive(RDFSDatatype datatype, RDFSLiteral literal) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 3);
        datatype.setPropertyValue(property, literal);
    }

    public void setMinInclusive(RDFSDatatype datatype, RDFSLiteral literal) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 4);
        datatype.setPropertyValue(property, literal);
    }

    public void setMinLength(RDFSDatatype datatype, int value) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 7);
        if (value >= 0) {
            datatype.setPropertyValue(property, new Integer(value));
        } else {
            datatype.setPropertyValues(property, Collections.EMPTY_LIST);
        }
    }

    public void setPattern(RDFSDatatype datatype, String value) {
        RDFProperty property = XSPNames.getRDFProperty(this.owlModel, 9);
        datatype.setPropertyValue(property, value);
    }
}

