/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteClassAction
extends ResourceAction {
    public static final String TEXT = "Delete class";

    public DeleteClassAction() {
        super(TEXT, OWLIcons.getDeleteClsIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        Collection clses = ComponentUtilities.getSelection((JTree)classTreePanel.getTree());
        DeleteClassAction.performAction(clses, classTreePanel);
    }

    private static boolean confirmDelete(Component parent) {
        boolean delete = true;
        if (ProjectManager.getProjectManager().getCurrentProject().getDisplayConfirmationOnRemove()) {
            String text = LocalizedText.getText((ResourceKey)ResourceKey.DIALOG_CONFIRM_DELETE_TEXT);
            delete = ProtegeUI.getModalDialogFactory().showConfirmDialog(parent, text, "Confirm Delete");
        }
        return delete;
    }

    @Override
    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof ClassTreePanel && resource instanceof RDFSNamedClass && resource.isEditable();
    }

    public static void performAction(RDFSNamedClass cls, ClassTreePanel classTreePanel) {
        DeleteClassAction.performAction((Collection<RDFSNamedClass>)Collections.singleton(cls), classTreePanel);
    }

    public static void performAction(Collection<RDFSNamedClass> clses, ClassTreePanel classTreePanel) {
        if (DeleteClassAction.confirmDelete((Component)((Object)classTreePanel))) {
            for (RDFSNamedClass cls : clses) {
                if (cls.getInstanceCount(true) > 0) {
                    String text = LocalizedText.getText((ResourceKey)ResourceKey.DELETE_CLASS_FAILED_DIALOG_TEXT);
                    text = String.valueOf(text) + "\n " + cls.getBrowserText();
                    ProtegeUI.getModalDialogFactory().showMessageDialog(cls.getOWLModel(), text);
                    continue;
                }
                JTree tree = classTreePanel.getTree();
                ComponentUtilities.removeSelection((JTree)tree);
                cls.delete();
            }
        }
    }
}

