/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OldRestrictionTreeNode
extends RestrictionTreeNode {
    private RDFSClass inheritedFromClass;
    private PropertyRestrictionsTree tree;

    public OldRestrictionTreeNode(PropertyRestrictionsTree tree, OWLRestriction restriction, RDFSClass inheritedFromClass) {
        this.inheritedFromClass = inheritedFromClass;
        this.tree = tree;
        this.setUserObject(restriction);
    }

    public void checkExpression(String text) throws Throwable {
        this.getRestriction().checkFillerText(text);
    }

    public String getFillerText() {
        return this.getRestriction().getFillerText();
    }

    public RDFSClass getInheritedFromClass() {
        return this.inheritedFromClass;
    }

    public char getOperator() {
        return this.getRestriction().getOperator();
    }

    public OWLRestriction getRestriction() {
        return (OWLRestriction)this.getUserObject();
    }

    public Cls getRestrictionMetaCls() {
        return this.getRestriction().getProtegeType();
    }

    public Icon getIcon() {
        OWLRestriction restriction = this.getRestriction();
        Icon baseIcon = ProtegeUI.getIcon(restriction);
        if (this.inheritedFromClass == null) {
            return baseIcon;
        }
        if (baseIcon instanceof ImageIcon) {
            return OWLIcons.getInheritedClsIcon((ImageIcon)baseIcon);
        }
        return baseIcon;
    }

    public boolean isInherited() {
        return this.inheritedFromClass != null;
    }

    public void setUserObject(Object userObject) {
        if (userObject instanceof String) {
            if (this.getRestriction().isIncluded()) {
                return;
            }
            String expr = (String)userObject;
            OWLModel owlModel = this.getRestriction().getOWLModel();
            try {
                this.getRestriction().checkFillerText(expr);
                try {
                    try {
                        owlModel.beginTransaction("Change restriction filler of " + this.getRestriction().getBrowserText() + " to " + expr);
                        this.getRestriction().setFillerText(expr);
                    }
                    catch (Exception ex) {
                        OWLUI.handleError(owlModel, ex);
                    }
                }
                finally {
                    owlModel.endTransaction();
                }
                this.updateConditionsWidget();
            }
            catch (Exception ex) {
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Illegal restriction filler: " + expr);
            }
        } else {
            super.setUserObject(userObject);
        }
    }

    private void updateConditionsWidget() {
        ConditionsWidget cw;
        Container c = this.tree.getParent();
        while (c != null && !(c instanceof InstanceDisplay)) {
            c = c.getParent();
        }
        if (c instanceof InstanceDisplay && (cw = (ConditionsWidget)((Object)OWLUI.searchComponentOfType(c, ConditionsWidget.class))) != null) {
            cw.repaint();
        }
    }
}

