/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ValidatableTabComponent;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.DatatypeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.FormsSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.ProtegeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.SearchSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.UISettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.VisibilityPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.WriterSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionPanel;
import edu.stanford.smi.protegex.owl.ui.projectview.ConfigureTabsPanel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferencesPanel
extends ValidatableTabComponent {
    private DatatypeSettingsPanel datatypeSettingsPanel;
    private JCheckBox encodeTagCheckBox;
    private ProfileSelectionPanel owlProfilePanel;
    private ConfigureTabsPanel configureTabsPanel;
    private UISettingsPanel uiSettingsPanel;
    private VisibilityPanel visibilityPanel;
    private OWLTestSettingsPanel testsPanel;

    public PreferencesPanel(OWLModel owlModel) {
        this.addComponents(owlModel);
    }

    private void addComponents(OWLModel owlModel) {
        JPanel generalTab = this.createGeneralTab(owlModel);
        JPanel encodingTab = this.createEncodingTab();
        this.visibilityPanel = new VisibilityPanel(owlModel);
        this.datatypeSettingsPanel = new DatatypeSettingsPanel(owlModel);
        this.configureTabsPanel = new ConfigureTabsPanel(ProtegeUI.getProjectView(owlModel.getProject()));
        this.testsPanel = new OWLTestSettingsPanel(owlModel);
        this.addTab("General", generalTab);
        this.addTab("Visibility", this.visibilityPanel);
        this.addTab("Datatypes", this.datatypeSettingsPanel);
        this.addTab("Searching", new SearchSettingsPanel(owlModel));
        this.addTab("Encoding", encodingTab);
        this.addTab("Tabs", (Component)((Object)this.configureTabsPanel));
        this.addTab("Tests", this.testsPanel);
    }

    private JPanel createGeneralTab(OWLModel owlModel) {
        JPanel generalTab = new JPanel();
        generalTab.setLayout(new BoxLayout(generalTab, 1));
        this.uiSettingsPanel = new UISettingsPanel(owlModel);
        generalTab.add(this.uiSettingsPanel);
        JPanel reasonerPanel = new JPanel(new BorderLayout(0, 8));
        reasonerPanel.setBorder(BorderFactory.createTitledBorder("Reasoning"));
        reasonerPanel.add("Center", (Component)new LabeledComponent("Reasoner URL", (Component)this.createValidatorField(), false));
        generalTab.add(reasonerPanel);
        if (owlModel instanceof JenaOWLModel) {
            generalTab.add(Box.createVerticalStrut(8));
            generalTab.add(new ProtegeSettingsPanel((JenaOWLModel)owlModel));
        }
        this.owlProfilePanel = new ProfileSelectionPanel(owlModel);
        generalTab.add(Box.createVerticalStrut(8));
        generalTab.add(this.owlProfilePanel);
        if (owlModel instanceof JenaOWLModel) {
            generalTab.add(Box.createVerticalStrut(8));
            generalTab.add(new WriterSettingsPanel((JenaOWLModel)owlModel));
        }
        if (AbsoluteFormsGenerator.optional) {
            generalTab.add(Box.createVerticalStrut(8));
            generalTab.add(new FormsSettingsPanel(owlModel));
        }
        JPanel container = new JPanel(new BorderLayout());
        container.add("North", generalTab);
        container.add("Center", new JPanel());
        return container;
    }

    private JPanel createEncodingTab() {
        this.encodeTagCheckBox = new JCheckBox("Don't write <?xml...> tag into RDF files", Jena.isXMLTagHidden());
        this.encodeTagCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Jena.setXMLTagHidden(PreferencesPanel.this.encodeTagCheckBox.isSelected());
            }
        });
        JPanel encodingTab = new JPanel();
        encodingTab.setLayout(new BoxLayout(encodingTab, 1));
        encodingTab.add(this.encodeTagCheckBox);
        return encodingTab;
    }

    private JTextField createValidatorField() {
        String reasonerURL = ReasonerPreferences.getInstance().getReasonerURL();
        final JTextField validatorField = new JTextField(reasonerURL);
        validatorField.setPreferredSize(new Dimension(300, 25));
        validatorField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            public void focusLost(FocusEvent arg0) {
                String newUrl = validatorField.getText();
                ReasonerPreferences.getInstance().setReasonerURL(newUrl);
            }
        });
        return validatorField;
    }

    public boolean getRequiresReloadUI() {
        return this.visibilityPanel.getRequiresReloadUI() || this.owlProfilePanel.getRequiresReloadUI() || this.datatypeSettingsPanel.getRequiresReloadUI() || this.uiSettingsPanel.getRequiresReloadUI() || this.configureTabsPanel.getRequiresReloadUI();
    }

    public void ok() {
        this.configureTabsPanel.saveContents();
    }
}

