/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.Action;
import javax.swing.JList;

public class OWLInversePropertyWidget
extends AbstractPropertyWidget {
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Set inverse property...", OWLIcons.getAddIcon("OWLObjectProperty"), false){

        public void resourceSelected(RDFResource resource) {
            OWLInversePropertyWidget.this.beginTransaction("Set inverse property");
            OWLProperty inverseProperty = (OWLProperty)resource;
            OWLInversePropertyWidget.this.adjustDomainAndRange((OWLProperty)OWLInversePropertyWidget.this.getEditedResource(), inverseProperty);
            OWLInversePropertyWidget.this.setInverseProperty(inverseProperty);
            OWLInversePropertyWidget.this.endTransaction();
        }

        public RDFResource pickResource() {
            Collection possibleInverses = OWLInversePropertyWidget.this.getPossibleInverses();
            if (possibleInverses.isEmpty()) {
                String text = "There are no existing properties which can be used as an inverse.";
                ProtegeUI.getModalDialogFactory().showMessageDialog(OWLInversePropertyWidget.this.getOWLModel(), text);
                return null;
            }
            return (OWLObjectProperty)ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)OWLInversePropertyWidget.this), OWLInversePropertyWidget.this.getOWLModel(), possibleInverses, "Select inverse property");
        }

        public Collection getSelectableResources() {
            return OWLInversePropertyWidget.this.getPossibleInverses();
        }
    };
    private AllowableAction createAction;
    private FrameListener frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            OWLInversePropertyWidget.this.updateWidget();
        }
    };
    private JList list;
    private AllowableAction removeAction;
    private AllowableAction viewAction;

    private void adjustDomainAndRange(OWLProperty forwardProperty, OWLProperty inverseProperty) {
        Collection range = forwardProperty.getUnionRangeClasses();
        ArrayList domain = new ArrayList(forwardProperty.getUnionDomain());
        Iterator it = domain.iterator();
        while (it.hasNext()) {
            Cls cls = (Cls)it.next();
            if (!(cls instanceof OWLAnonymousClass)) continue;
            it.remove();
        }
        if (domain.size() != 1 || !domain.contains(this.getOWLModel().getOWLThingClass())) {
            inverseProperty.setUnionRangeClasses(domain);
        }
        if (inverseProperty.isDomainDefined()) {
            inverseProperty.setDomainDefined(false);
        }
        if (!inverseProperty.getUnionDomain().isEmpty()) {
            inverseProperty.removeUnionDomainClass(this.getOWLModel().getOWLThingClass());
        }
        if (range.isEmpty() && inverseProperty.getSuperpropertyCount() == 0) {
            range = Collections.singleton(this.getOWLModel().getOWLThingClass());
        }
        this.setDomain(inverseProperty, range);
        if (!forwardProperty.isDomainDefined()) {
            inverseProperty.setDomainDefined(false);
        }
    }

    private RDFProperty createInverseProperty() {
        OWLProperty inverseProperty = null;
        try {
            try {
                OWLProperty forwardProperty = (OWLProperty)this.getEditedResource();
                this.beginTransaction("Create inverse property for " + forwardProperty.getName());
                String propertyName = "";
                String prefix = forwardProperty.getNamespacePrefix();
                if (prefix != null && prefix.length() > 0) {
                    propertyName = String.valueOf(prefix) + ":";
                }
                propertyName = String.valueOf(propertyName) + "inverse_of_" + forwardProperty.getLocalName();
                while (this.getKnowledgeBase().getFrame(propertyName) != null) {
                    propertyName = String.valueOf(propertyName) + "_";
                }
                Collection inverseSuperproperties = this.getSuperpropertyInverses(forwardProperty);
                RDFSNamedClass type = (RDFSNamedClass)forwardProperty.getRDFType();
                inverseProperty = (OWLProperty)this.getKnowledgeBase().createSlot(propertyName, (Cls)type, inverseSuperproperties, true);
                this.adjustDomainAndRange(forwardProperty, inverseProperty);
                inverseProperty.setFunctional(false);
                this.setInverseProperty(inverseProperty);
                if (forwardProperty.isAnnotationProperty() && !inverseProperty.isAnnotationProperty()) {
                    inverseProperty.addProtegeType(forwardProperty.getOWLModel().getOWLAnnotationPropertyClass());
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.endTransaction();
        }
        return inverseProperty;
    }

    private Collection getSuperpropertyInverses(RDFProperty forwardProperty) {
        LinkedHashSet<RDFProperty> superpropertyInverses = new LinkedHashSet<RDFProperty>();
        for (RDFProperty superproperty : forwardProperty.getSuperproperties(true)) {
            RDFProperty superpropertyInverse = superproperty.getInverseProperty();
            if (superpropertyInverse == null) continue;
            superpropertyInverses.add(superpropertyInverse);
        }
        return superpropertyInverses;
    }

    private JList createList() {
        SelectableList list = ComponentFactory.createSingleItemList((Action)this.getViewAction());
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    private Action getCreateAction() {
        if (this.createAction == null) {
            this.createAction = new CreateAction("Create new inverse property"){

                public void onCreate() {
                    RDFProperty property = OWLInversePropertyWidget.this.createInverseProperty();
                    OWLInversePropertyWidget.this.getProject().show((Instance)property);
                }
            };
        }
        return this.createAction;
    }

    protected Collection getPossibleInverses() {
        ArrayList<RDFProperty> possibleInverses = new ArrayList<RDFProperty>();
        OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        for (RDFProperty property : owlModel.getVisibleUserDefinedOWLProperties()) {
            RDFProperty inverseProperty;
            if (!(property instanceof OWLObjectProperty) || (inverseProperty = property.getInverseProperty()) != null) continue;
            possibleInverses.add(property);
        }
        return possibleInverses;
    }

    private Action getRemoveAction() {
        if (this.removeAction == null) {
            this.removeAction = new RemoveAction("Remove inverse property", (Selectable)this){

                public void onRemove(Object o) {
                    OWLInversePropertyWidget.this.setInverseProperty(null);
                }
            };
        }
        return this.removeAction;
    }

    public Collection getSelection() {
        return this.getValues();
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues((JList)this.list);
    }

    private Action getViewAction() {
        if (this.viewAction == null) {
            this.viewAction = new ViewAction("View inverse property", (Selectable)this){

                public void onView(Object o) {
                    RDFProperty property = (RDFProperty)o;
                    OWLInversePropertyWidget.this.getProject().show((Instance)property);
                }
            };
        }
        return this.viewAction;
    }

    public void initialize() {
        this.list = this.createList();
        LabeledComponent c = new LabeledComponent(this.getLabel(), (Component)this.list);
        c.addHeaderButton(this.getViewAction());
        c.addHeaderButton(this.getCreateAction());
        this.addAction.activateComboBox(c.addHeaderButton((Action)this.addAction));
        c.addHeaderButton(this.getRemoveAction());
        this.add((Component)c);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
        LabeledComponent oldLabeledComponent = (LabeledComponent)this.getComponent(0);
        ArrayList actions = new ArrayList(oldLabeledComponent.getHeaderButtonActions());
        this.createAction.putValue("SmallIcon", (Object)OWLIcons.getCreatePropertyIcon("OWLObjectProperty"));
        this.createAction.putValue("ShortDescription", (Object)"Create new inverse property");
        Action addAction = (Action)actions.get(2);
        addAction.putValue("SmallIcon", OWLIcons.getAddIcon("OWLObjectProperty"));
        addAction.putValue("ShortDescription", "Assign existing property");
        Action removeAction = (Action)actions.get(3);
        removeAction.putValue("SmallIcon", OWLIcons.getRemoveIcon("OWLObjectProperty"));
        removeAction.putValue("ShortDescription", "Unassign current inverse property");
        OWLLabeledComponent lc = new OWLLabeledComponent("Inverse", oldLabeledComponent.getCenterComponent());
        lc.addHeaderButton((Action)this.createAction);
        lc.addHeaderButton(addAction);
        lc.addHeaderButton(removeAction);
        this.remove((Component)oldLabeledComponent);
        this.add((Component)((Object)lc));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("owl:inverseOf");
    }

    private void setDomain(RDFProperty property, Collection domain) {
        for (Cls cls : domain) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            property.addUnionDomainClass((RDFSClass)cls);
        }
    }

    public void setEditable(boolean b) {
        this.updateWidget();
    }

    public void setInstance(Instance newInstance) {
        RDFResource oldInstance = this.getEditedResource();
        if (oldInstance != null && !this.isSlotAtCls()) {
            oldInstance.removeFrameListener(this.frameListener);
        }
        super.setInstance(newInstance);
        if (newInstance != null && !this.isSlotAtCls()) {
            newInstance.addFrameListener(this.frameListener);
        }
    }

    private void setInverseProperty(RDFProperty property) {
        if (property == null) {
            ComponentUtilities.setListValues((JList)this.list, (Collection)Collections.EMPTY_LIST);
        } else {
            ComponentUtilities.setListValues((JList)this.list, (Collection)Collections.singleton(property));
        }
        this.valueChanged();
        if (this.getEditedResource() instanceof OWLObjectProperty) {
            OWLObjectProperty objectSlot = (OWLObjectProperty)this.getEditedResource();
            objectSlot.setSymmetric(objectSlot.equals(property));
        }
        if (this.getEditedResource() instanceof RDFProperty) {
            ((RDFProperty)this.getEditedResource()).synchronizeDomainAndRangeOfInverse();
        }
    }

    public void setValues(Collection c) {
        ComponentUtilities.setListValues((JList)this.list, (Collection)c);
    }

    private void updateWidget() {
        boolean editable;
        RDFResource resource = this.getEditedResource();
        boolean bl = editable = !this.isSlotAtCls() && resource.isEditable();
        if (editable && resource instanceof Slot) {
            ValueType type = ((Slot)resource).getValueType();
            editable = OWLInversePropertyWidget.equals((Object)type, (Object)ValueType.INSTANCE) || OWLInversePropertyWidget.equals((Object)type, (Object)ValueType.CLS);
        }
        this.createAction.setAllowed(editable);
        this.addAction.setEnabled(editable);
        this.removeAction.setAllowed(editable);
    }
}

