/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FormsPanel;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.FormsTab;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class OWLFormsTab
extends FormsTab
implements HostResourceDisplay {
    private SelectableTree theTree;

    public void initialize() {
        super.initialize();
        FormsPanel panel = (FormsPanel)this.getSubComponent((Component)((Object)this), FormsPanel.class);
        LabeledComponent lc = (LabeledComponent)this.getSubComponent((Component)panel, LabeledComponent.class);
        this.theTree = (SelectableTree)panel.getSelectable();
        FindInDialogAction fAction = new FindInDialogAction(new DefaultClassFind((OWLModel)this.getKnowledgeBase(), 1), Icons.getFindFormIcon(), this, true);
        ResourceFinder finder = new ResourceFinder(fAction);
        lc.setFooterComponent((JComponent)finder);
    }

    private Object getSubComponent(Component start, Class searchClass) {
        Component component = null;
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(start);
        while (component == null && components.size() > 0) {
            Component current = (Component)components.remove(0);
            if (searchClass.isAssignableFrom(current.getClass())) {
                component = current;
                continue;
            }
            if (!(current instanceof Container)) continue;
            components.addAll((Collection)Arrays.asList(((Container)current).getComponents()));
        }
        return component;
    }

    public boolean displayHostResource(RDFResource resource) {
        List objectPath;
        TreePath path;
        if (resource instanceof RDFSClass && !this.getSelection().contains(resource) && (path = ComponentUtilities.getTreePath((JTree)this.theTree, (Collection)(objectPath = this.getPathToRoot((RDFSClass)resource, new LinkedList())))) != null) {
            WaitCursor cursor = new WaitCursor((Component)((Object)this));
            this.theTree.scrollPathToVisible(path);
            this.theTree.setSelectionPath(path);
            this.theTree.updateUI();
            cursor.hide();
            return true;
        }
        return false;
    }

    private List getPathToRoot(RDFSClass cls, LinkedList list) {
        list.add(0, cls);
        OWLNamedClass rootCls = cls.getOWLModel().getOWLThingClass();
        Collection superclasses = cls.getSuperclasses(false);
        for (Cls superclass : superclasses) {
            if (superclass.equals(rootCls)) {
                list.add(0, superclass);
                return list;
            }
            if (!cls.isVisible() || !(superclass instanceof OWLNamedClass)) continue;
            this.getPathToRoot((OWLNamedClass)superclass, list);
            break;
        }
        return list;
    }
}

