/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.awt.BorderLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimePanel
extends JPanel {
    private Listener listener;
    private JTextField hoursField;
    private JTextField minutesField;
    private JTextField secondsField;

    public TimePanel(Listener listener) {
        this.listener = listener;
        this.hoursField = new JTextField(2);
        this.minutesField = new JTextField(2);
        this.secondsField = new JTextField(2);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                TimePanel.this.notifyListener();
            }
        };
        this.hoursField.addFocusListener(focusListener);
        this.minutesField.addFocusListener(focusListener);
        this.secondsField.addFocusListener(focusListener);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 0));
        leftPanel.add(this.hoursField);
        leftPanel.add(new JLabel(":"));
        leftPanel.add(this.minutesField);
        leftPanel.add(new JLabel(":"));
        leftPanel.add(this.secondsField);
        this.setLayout(new BorderLayout());
        this.add("West", leftPanel);
        this.add("Center", Box.createHorizontalGlue());
    }

    public void clear() {
        this.hoursField.setText("");
        this.minutesField.setText("");
        this.secondsField.setText("");
    }

    private int getInt(JTextField textField, int max) {
        String str = textField.getText();
        return this.getInt(str, max);
    }

    private int getInt(String str, int max) {
        try {
            int value = Integer.parseInt(str);
            if (value >= 0 && value < max) {
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private String getString(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    public String getTime() {
        int hours = this.getInt(this.hoursField, 24);
        int minutes = this.getInt(this.minutesField, 60);
        int seconds = this.getInt(this.secondsField, 60);
        return XMLSchemaDatatypes.getTimeString(hours, minutes, seconds);
    }

    public boolean isNull() {
        return this.hoursField.getText().length() + this.minutesField.getText().length() + this.secondsField.getText().length() == 0;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.timeChanged(this);
        }
    }

    public void setTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.setTime(cal.get(11), cal.get(12), cal.get(13));
    }

    public void setTime(String literal) {
        String[] ss = literal.split(":");
        int hours = ss.length > 0 ? this.getInt(ss[0], 24) : 0;
        int minutes = ss.length > 1 ? this.getInt(ss[1], 60) : 0;
        int seconds = ss.length > 2 ? this.getInt(ss[2], 60) : 0;
        this.setTime(hours, minutes, seconds);
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.hoursField.setText(this.getString(hours));
        this.minutesField.setText(this.getString(minutes));
        this.secondsField.setText(this.getString(seconds));
    }

    public static interface Listener {
        public void timeChanged(TimePanel var1);
    }
}

