/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.syntax.sirpac;

import edu.stanford.db.rdf.syntax.generic.DumpConsumer;
import edu.stanford.db.rdf.vocabulary.order_20000527.RDFX;
import edu.stanford.db.xml.util.ErrorStore;
import edu.stanford.db.xml.util.GenericParser;
import edu.stanford.db.xml.util.QName;
import java.io.CharArrayReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.rdf.implementation.syntax.sirpac.Data;
import org.w3c.rdf.implementation.syntax.sirpac.Element;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFConsumer;
import org.w3c.rdf.syntax.RDFParser;
import org.w3c.rdf.util.RDFReader;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.ParserFactory;

public class SiRPAC
implements EntityResolver,
DTDHandler,
DocumentHandler,
RDFParser {
    public static final String REVISION = "$Id: SiRPAC.java,v 1.15 1999/12/05 22:08:12 smelnik Exp $";
    public static final String RDFMS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDFSCHEMA = "http://www.w3.org/TR/1999/PR-rdf-schema-19990303#";
    public static final String XMLSCHEMA = new String("xml");
    static final QName UNQUALIFIED_parseType = new QName(null, "parseType");
    static final QName RDFMS_parseType = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
    static final String RDFMS_parseType_Resource = "Resource";
    static final String XML_space = String.valueOf(XMLSCHEMA) + "space";
    static final String XML_space_preserve = "preserve";
    static final String XMLNS = "xmlns";
    static final String XMLNS_COLON = "xmlns:";
    static final String _RDF = "RDF";
    static final String DESCRIPTION = "Description";
    static final QName UNQUALIFIED_about = new QName(null, "about");
    static final QName RDFMS_about = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
    static final QName RDFMS_bagID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
    static final QName UNQUALIFIED_ID = new QName(null, "ID");
    static final QName RDFMS_ID = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
    static final QName UNQUALIFIED_resource = new QName(null, "resource");
    static final QName RDFMS_resource = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
    static final String RDFMS_aboutEach = "http://www.w3.org/1999/02/22-rdf-syntax-ns#aboutEach";
    static final String RDFMS_aboutEachPrefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#aboutEachPrefix";
    static final String RDFMS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF";
    static final String RDFMS_Description = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Description";
    static final String RDFMS_Seq = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq";
    static final String RDFMS_Alt = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt";
    static final String RDFMS_Bag = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag";
    boolean ENABLE_EXPERIMENTAL = true;
    private Stack m_namespaceStack = new Stack();
    private Stack m_elementStack = new Stack();
    private Element m_root = null;
    private String m_sSource = null;
    private boolean m_sSourceModified = false;
    private static Vector s_vNStodo = new Vector();
    private static Vector s_vNSdone = new Vector();
    private boolean m_bCreateBags = false;
    private boolean m_bFetchSchemas = false;
    private Stack m_parseTypeStack = new Stack();
    private Stack m_parseElementStack = new Stack();
    private String m_sLiteral = new String();
    private RDFConsumer m_consumer;
    private InputSource m_RDFsource = null;
    private String m_sXMLParser = null;
    boolean ignoreExternalEntities = false;
    NodeFactory nodeFactory;
    static final String DEFAULT_PARSER = "org.brownell.xml.aelfred2.SAXDriver";
    Locator locator = new LocatorImpl();
    private static final int smSKIPPING = 0;
    private static final int smRDF = 1;
    private static final int smDESCRIPTION = 2;
    private static final int smTOP_DESCRIPTION = 3;
    private int scanMode = 0;
    private Element scanModeElement = null;
    private Vector m_vResources = new Vector();
    private Vector m_vResolveQueue = new Vector();
    private boolean streamMode = true;
    private boolean robustMode = false;
    private ErrorHandler errorHandler = null;
    private Hashtable m_hIDtable = new Hashtable();
    private int m_iReificationCounter = 0;

    public SiRPAC() {
        try {
            if (System.getProperty("org.xml.sax.parser") == null) {
                ((Hashtable)System.getProperties()).put("org.xml.sax.parser", DEFAULT_PARSER);
            }
        }
        catch (SecurityException securityException) {
            this.m_sXMLParser = DEFAULT_PARSER;
        }
    }

    public SiRPAC(String string) {
        this.m_sXMLParser = string;
    }

    public void addError(String string) throws SAXException {
        this.errorHandler.fatalError(new SAXParseException(string, this.locator));
    }

    private Statement addOrder(Element element, int n, Statement statement, Resource resource, Resource resource2, RDFNode rDFNode) throws SAXException, ModelException {
        if (!this.ENABLE_EXPERIMENTAL) {
            return null;
        }
        if (n == 2) {
            this.addTriple(this.nodeFactory.createStatement(statement, this.createResource(RDFX.order.getURI()), this.createLiteral("1")));
        }
        Statement statement2 = this.nodeFactory.createStatement(resource2, resource, rDFNode);
        this.addTriple(statement2);
        String string = element.getAttribute(RDFX.order.getURI());
        String string2 = element.getAttribute(RDFX.backwardOrder.getURI());
        if (statement != null && string != null) {
            this.addError("SM: two statements " + statement + " and " + statement2 + " cannot have the same forward order");
        }
        if (string == null && n > 1) {
            string = String.valueOf(n);
        }
        if (string != null) {
            this.addTriple(this.createResource(RDFX.order.getURI()), statement2, this.createLiteral(string));
        }
        if (string2 != null) {
            this.addTriple(this.createResource(RDFX.backwardOrder.getURI()), statement2, this.createLiteral(string2));
        }
        return statement2;
    }

    public void addTriple(Resource resource, Resource resource2, RDFNode rDFNode) throws SAXException, ModelException {
        if (resource == null) {
            this.addWarning("Predicate null when subject=" + resource2 + " and object=" + rDFNode);
            return;
        }
        if (resource2 == null) {
            this.addWarning("Subject null when predicate=" + resource + " and object=" + rDFNode);
            return;
        }
        if (rDFNode == null) {
            this.addWarning("Object null when predicate=" + resource + " and subject=" + resource2);
            return;
        }
        if (resource2.toString() == null || resource2.toString().length() == 0) {
            if (this.source() == null) {
                this.addError("XML document refers to the source URL. The source URL has not been set.");
            }
            resource2 = this.createResource(this.source());
        }
        this.addTriple(this.nodeFactory.createStatement(resource2, resource, rDFNode));
    }

    protected void addTriple(Statement statement) throws SAXException, ModelException {
        this.m_consumer.addStatement(statement);
    }

    public void addWarning(String string) throws SAXException {
        this.errorHandler.warning(new SAXParseException(string, this.locator));
    }

    static void bailOut() {
        System.err.println("Usage: java -Dorg.xml.sax.parser=<classname> org.w3c.rdf.SiRPAC [-robust | -r] [-orthodox -o] [ URI | filename ]");
        System.err.println("This is revision $Id: SiRPAC.java,v 1.15 1999/12/05 22:08:12 smelnik Exp $");
        System.exit(1);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object object;
        Element element = (Element)this.m_elementStack.peek();
        String string = new String(cArray, n, n2);
        if (this.parseLiteral()) {
            this.makeMarkupChar(string);
            return;
        }
        boolean bl = false;
        Data data = null;
        Enumeration enumeration = element.children();
        while (enumeration.hasMoreElements()) {
            object = (Element)enumeration.nextElement();
            if (!(object instanceof Data)) continue;
            bl = true;
            data = (Data)object;
            break;
        }
        object = string.trim();
        if (((String)object).length() > 0 || this.preserveWhiteSpace()) {
            if (!bl) {
                element.addChild(new Data(string));
            } else {
                data.set(String.valueOf(data.data()) + string);
            }
        }
    }

    private void checkAttributes(Element element) throws SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        this.getCompatibilityAttribute(UNQUALIFIED_parseType, RDFMS_parseType, element);
        String string6 = this.getCompatibilityAttribute(UNQUALIFIED_resource, RDFMS_resource, element);
        if (string6 != null) {
            if (string6.startsWith("#") && !this.streamMode) {
                this.resolveLater(element);
                element.resource(string6);
            } else {
                element.resource(string6, this.source());
            }
        }
        if ((string5 = element.getAttribute(RDFMS_aboutEach)) != null && string5.startsWith("#")) {
            this.resolveLater(element);
            element.aboutEach(string5);
        }
        if ((string4 = element.getAttribute(RDFMS_aboutEachPrefix)) != null) {
            this.resolveLater(element);
            element.aboutEachPrefix(string4);
        }
        if ((string3 = this.getCompatibilityAttribute(UNQUALIFIED_about, RDFMS_about, element)) != null) {
            if (string3.startsWith("#") && !this.streamMode) {
                this.resolveLater(element);
                element.about(string3);
            } else {
                this.registerResource(element);
                element.about(string3, this.source());
            }
        }
        if ((string2 = element.getAttribute(RDFMS_bagID)) != null) {
            element.bagID(string2, this.source());
            string2 = element.bagID();
            this.registerID(string2, element);
        }
        if ((string = this.getCompatibilityAttribute(UNQUALIFIED_ID, RDFMS_ID, element)) != null) {
            element.ID(string, this.source());
            string = element.ID();
            this.registerID(string, element);
        }
        if (this.streamMode && (string5 != null || string4 != null)) {
            this.addError("aboutEach and aboutEachPrefix are not supported in the stream mode");
        }
        if (string != null && string3 != null) {
            this.addError("A description block cannot use both 'ID' and 'about' attributes - see <a href=\"http://www.w3.org/TR/REC-rdf-syntax/#idAboutAttr\">[6.5]</a");
        }
    }

    public void createBags(boolean bl) {
        this.m_bCreateBags = bl;
    }

    private Literal createLiteral(String string) throws ModelException {
        return this.nodeFactory.createLiteral(GenericParser.create(string));
    }

    public Literal createLiteral(String string, boolean bl) throws ModelException {
        return this.nodeFactory.createLiteral(GenericParser.create(string));
    }

    public static Parser createParser(String string) {
        Parser parser = null;
        try {
            Class<?> clazz = Class.forName(string);
            parser = (Parser)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("SAX parser class " + string + "cannot be loaded.");
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("SAX parser class " + string + " does not have a zero-argument constructor.");
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("SAX parser class " + string + " cannot be instantiated.");
            System.exit(1);
        }
        if (!(parser instanceof Parser)) {
            System.err.println("Class " + string + " does not implement org.xml.sax.Parser.");
            System.exit(1);
        }
        return parser;
    }

    public Resource createResource(String string) throws ModelException {
        Enumeration enumeration = this.listNamespaces();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            return this.createResource(string2, string.substring(string2.length()));
        }
        int n = string.length() - 1;
        while (n > 0) {
            char c = string.charAt(n);
            switch (c) {
                case '#': 
                case '/': 
                case ':': 
                case '\\': {
                    String string3 = n < string.length() - 1 ? string.substring(n + 1) : "";
                    String string4 = string.substring(0, n + 1);
                    return this.createResource(string4, string3);
                }
            }
            --n;
        }
        return this.nodeFactory.createResource(GenericParser.create(string));
    }

    public Resource createResource(String string, String string2) throws ModelException {
        Resource resource = this.nodeFactory.createResource(GenericParser.create(string), GenericParser.create(string2));
        return resource;
    }

    public void doctype(String string, String string2, String string3) {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        try {
            boolean bl = this.parseLiteral();
            this.m_root = (Element)this.m_elementStack.pop();
            this.m_namespaceStack.pop();
            if (this.scanMode == 0) {
                return;
            }
            if (bl) {
                Element element = (Element)this.m_parseElementStack.peek();
                if (element != this.m_root) {
                    this.makeMarkupET(String.valueOf(this.m_root.prefix()) + string);
                } else {
                    this.m_root.addChild(new Data(this.m_sLiteral, true));
                    this.m_sLiteral = "";
                    this.m_parseElementStack.pop();
                    this.m_parseTypeStack.pop();
                }
            } else if (this.parseResource() && !this.m_elementStack.empty()) {
                Element element = (Element)this.m_parseElementStack.peek();
                if (this.m_elementStack.peek() == element) {
                    Element element2 = (Element)this.m_elementStack.pop();
                    this.m_parseElementStack.pop();
                    this.m_parseTypeStack.pop();
                }
            }
            if (this.scanMode == 1) {
                this.scanMode = 0;
                if (!this.streamMode) {
                    this.resolve();
                    this.processXML(this.m_root);
                }
                return;
            }
            if (this.scanModeElement != this.m_root) {
                return;
            }
            switch (this.scanMode) {
                case 3: {
                    this.preProcessXML(this.scanModeElement);
                    this.scanMode = 0;
                    break;
                }
                case 2: {
                    this.preProcessXML(this.scanModeElement);
                    this.scanMode = 1;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ModelException modelException) {
            throw new SAXException(modelException);
        }
    }

    private static String escapeCharacters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n + n2) {
            if (cArray[n3] >= ' ' && cArray[n3] < '\u007f') {
                stringBuffer.append(cArray[n3]);
            } else {
                stringBuffer.append("&#" + cArray[n3] + ';');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private boolean expandAttributes(Element element, Element element2, boolean bl) throws SAXException {
        boolean bl2 = false;
        Enumeration enumeration = element2.attributes();
        while (enumeration.hasMoreElements()) {
            QName qName = (QName)enumeration.nextElement();
            String string = element2.getAttribute(qName);
            if (XMLSCHEMA.equals(qName.getNamespace()) || RDFMS.equals(qName.getNamespace()) && !qName.getLocalName().startsWith("_") && !qName.getLocalName().endsWith("value") && !qName.getLocalName().endsWith("type") || this.ENABLE_EXPERIMENTAL && "http://interdataworking.com/vocabulary/order-20000527#".equals(qName.getNamespace())) continue;
            if (bl && !qName.equals(RDFMS_resource) && !qName.equals(UNQUALIFIED_resource)) {
                this.addError("[SM] Property element " + element2.name() + " has invalid attribute '" + qName + "'. Only rdf:resource is allowed.");
            }
            bl2 = true;
            Element element3 = new Element(qName.getNamespace(), qName.getLocalName(), new AttributeListImpl());
            Data data = new Data(string);
            element3.addChild(data);
            element.addChild(element3);
        }
        return bl2;
    }

    private void fetchRDF() throws Exception {
        Parser parser = null;
        parser = this.m_sXMLParser == null ? ParserFactory.makeParser() : ParserFactory.makeParser(this.m_sXMLParser);
        parser.setEntityResolver(this);
        parser.setDTDHandler(this);
        parser.setDocumentHandler(this);
        parser.setErrorHandler(this.errorHandler);
        this.setSource(this.m_RDFsource.getSystemId());
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.source() != null) {
            hashtable.put(XMLNS, this.source());
        }
        this.m_namespaceStack.push(hashtable);
        parser.parse(this.m_RDFsource);
    }

    public void fetchSchema(String string) {
    }

    public void fetchSchemas(boolean bl) {
        this.m_bFetchSchemas = bl;
    }

    String getCompatibilityAttribute(QName qName, QName qName2, Element element) {
        String string = element.getAttribute(qName);
        if (string != null) {
            element.addAttribute(qName2, string);
            element.removeAttribute(qName);
        } else {
            string = element.getAttribute(qName2);
        }
        return string;
    }

    public InputSource getRDFSource() {
        return this.m_RDFsource;
    }

    private boolean hasString(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string.equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void ignoreExternalEntities(boolean bl) {
        this.ignoreExternalEntities = bl;
    }

    public boolean isAlternative(Element element) {
        return RDFMS_Alt.equals(element.name());
    }

    public boolean isBag(Element element) {
        return RDFMS_Bag.equals(element.name());
    }

    public boolean isContainer(Element element) {
        return this.isSequence(element) || this.isAlternative(element) || this.isBag(element);
    }

    public boolean isDescription(Element element) {
        return RDFMS_Description.equals(element.name());
    }

    public boolean isListItem(Element element) {
        return this.isRDF(element) && (element.name().endsWith("li") || element.name().indexOf("_") > -1);
    }

    public boolean isRDF(Element element) {
        if (element != null && element.name() != null) {
            return element.name().startsWith(RDFMS);
        }
        return false;
    }

    public boolean isRDFroot(Element element) {
        return RDFMS_RDF.equals(element.name());
    }

    public boolean isSequence(Element element) {
        return RDFMS_Seq.equals(element.name());
    }

    public boolean isTypedPredicate(Element element) {
        String string = element.name();
        if (RDFMS_resource.equals(string)) {
            return false;
        }
        return string.length() > 0;
    }

    public Enumeration listNamespaces() {
        return s_vNSdone.elements();
    }

    public Element lookforNode(String string) {
        if (string == null) {
            return null;
        }
        return (Element)this.m_hIDtable.get(String.valueOf(this.source()) + string);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        SiRPAC siRPAC = new SiRPAC();
        String string = null;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).startsWith("-r")) {
                siRPAC.setRobustMode(true);
            } else if (((String)object).startsWith("-o")) {
                siRPAC.useExperimentalFeatures(false);
            } else {
                string = stringArray[n];
                if (n + 1 < stringArray.length) {
                    SiRPAC.bailOut();
                }
            }
            ++n;
        }
        object = GenericParser.getInputSource(string);
        DumpConsumer dumpConsumer = new DumpConsumer();
        ErrorStore errorStore = new ErrorStore();
        siRPAC.setErrorHandler(errorStore);
        try {
            siRPAC.parse((InputSource)object, dumpConsumer);
        }
        catch (SAXException sAXException) {
            System.err.println("Error during parsing: " + sAXException.getMessage());
            sAXException.getException().printStackTrace(System.err);
        }
        String string2 = errorStore.errors();
        if (string2 != null && string2.length() > 0) {
            System.err.println("Errors during parsing:\n" + string2);
        }
    }

    public void makeMarkupChar(String string) {
        this.m_sLiteral = String.valueOf(this.m_sLiteral) + string;
    }

    public void makeMarkupET(String string) {
        this.m_sLiteral = String.valueOf(this.m_sLiteral) + "</" + string + ">";
    }

    public void makeMarkupST(Element element) {
        this.m_sLiteral = String.valueOf(this.m_sLiteral) + "<" + element.name();
        Enumeration enumeration = element.attributes();
        while (enumeration.hasMoreElements()) {
            QName qName = (QName)enumeration.nextElement();
            String string = element.getAttribute(qName);
            this.m_sLiteral = String.valueOf(this.m_sLiteral) + " " + qName + "='" + string + "'";
        }
        this.m_sLiteral = String.valueOf(this.m_sLiteral) + ">";
    }

    public String namespace(String string) throws SAXException {
        if (string == null) {
            string = XMLNS;
        }
        int n = this.m_namespaceStack.size() - 1;
        while (n >= 0) {
            Hashtable hashtable = (Hashtable)this.m_namespaceStack.elementAt(n);
            String string2 = (String)hashtable.get(string);
            if (string2 != null) {
                return string2;
            }
            --n;
        }
        if (string.equals(XMLSCHEMA)) {
            return XMLSCHEMA;
        }
        if (string.equals(XMLNS)) {
            return "";
        }
        this.addError("Unresolved namespace prefix " + string);
        return "";
    }

    public String newReificationID() {
        ++this.m_iReificationCounter;
        String string = this.source() != null ? Element.makeAbsolute(new String("genid" + this.m_iReificationCounter), this.source()) : new String("#genid" + this.m_iReificationCounter);
        return string;
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void parse(InputSource inputSource, RDFConsumer rDFConsumer) throws SAXException {
        if (this.errorHandler == null) {
            this.errorHandler = new ErrorStore();
        }
        try {
            this.setRDFSource(this.robustMode ? RDFReader.filter(inputSource) : inputSource);
            this.m_consumer = rDFConsumer;
            this.m_consumer.startModel();
            this.nodeFactory = this.m_consumer.getNodeFactory();
            this.fetchRDF();
            this.m_consumer.endModel();
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException("Fatal error", exception);
        }
    }

    public boolean parseLiteral() {
        if (!this.m_elementStack.empty()) {
            int n = this.m_elementStack.size() - 1;
            while (n >= 0) {
                Element element = (Element)this.m_elementStack.elementAt(n);
                String string = element.getAttribute(RDFMS_parseType);
                if (string != null && !string.equals(RDFMS_parseType_Resource)) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    public boolean parseResource() {
        if (!this.m_elementStack.empty()) {
            int n = this.m_elementStack.size() - 1;
            while (n >= 0) {
                Element element = (Element)this.m_elementStack.elementAt(n);
                String string = element.getAttribute(RDFMS_parseType);
                if (string != null && string.equals(RDFMS_parseType_Resource)) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    void preProcessXML(Element element) throws SAXException, ModelException {
        if (this.streamMode) {
            this.processXML(element);
        }
    }

    public boolean preserveWhiteSpace() {
        int n;
        Element element;
        String string;
        if (!this.m_elementStack.empty() && (string = (element = (Element)this.m_elementStack.elementAt(n = this.m_elementStack.size() - 1)).getAttribute(XML_space)) != null) {
            return XML_space_preserve.equals(string);
        }
        return false;
    }

    private String processContainer(Element element) throws SAXException, ModelException {
        Object object;
        String string = element.ID();
        if (string == null) {
            string = element.about();
        }
        if (string == null) {
            string = this.newReificationID();
        }
        if (!element.done()) {
            object = RDFMS;
            if (this.isSequence(element)) {
                this.addTriple(this.createResource(RDFMS, "type"), this.createResource(string), this.createResource(RDFMS_Seq));
            } else if (this.isAlternative(element)) {
                this.addTriple(this.createResource(RDFMS, "type"), this.createResource(string), this.createResource(RDFMS_Alt));
            } else if (this.isBag(element)) {
                this.addTriple(this.createResource(RDFMS, "type"), this.createResource(string), this.createResource(RDFMS_Bag));
            }
            element.done(true);
        }
        this.expandAttributes(element, element, false);
        object = element.children();
        if (!object.hasMoreElements() && this.isAlternative(element)) {
            this.addError("An RDF:Alt container must have at least one nested listitem");
        }
        int n = 1;
        while (object.hasMoreElements()) {
            Element element2 = (Element)object.nextElement();
            if (this.isListItem(element2)) {
                this.processListItem(string, element2, n);
                ++n;
                continue;
            }
            this.addError("Cannot nest " + element2.name() + " inside a container (Bag/Alt/Seq)");
        }
        return string;
    }

    public String processDescription(Element element, boolean bl, boolean bl2, boolean bl3) throws SAXException, ModelException {
        if (element.done()) {
            return element.ID();
        }
        int n = 1;
        boolean bl4 = true;
        String string = element.ID();
        String string2 = element.bagID();
        String string3 = element.about();
        String string4 = element.aboutEach();
        String string5 = element.aboutEachPrefix();
        Element element2 = element.target();
        boolean bl5 = element2 != null;
        boolean bl6 = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (bl5) {
            string6 = element2.about();
            string8 = element2.ID();
            string7 = element2.bagID();
            if (string7 != null && string3 != null) {
                bl6 = string3.substring(1).equals(string7);
            } else if (string8 != null && string3 != null && string3.substring(1).equals(string8) && this.isContainer(element2)) {
                bl6 = true;
            }
        }
        this.expandAttributes(element, element, false);
        if (string4 != null && bl5) {
            if (this.isContainer(element2)) {
                Enumeration enumeration = element2.children();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Element element3 = (Element)enumeration.nextElement();
                    if (this.isListItem(element3)) {
                        Element element4;
                        object3 = element3.resource();
                        if (object3 != null) {
                            object2 = null;
                            object2 = new Element(RDFMS_Description, new AttributeListImpl());
                            ((Element)object2).about((String)object3);
                            object = element.children();
                            while (object.hasMoreElements()) {
                                element4 = (Element)object.nextElement();
                                if (object2 == null) continue;
                                ((Element)object2).addChild(element4);
                            }
                            if (object2 == null) continue;
                            this.processDescription((Element)object2, false, false, false);
                            continue;
                        }
                        object2 = element3.children();
                        while (object2.hasMoreElements()) {
                            object = (Element)object2.nextElement();
                            element4 = new Element(RDFMS_Description, new AttributeListImpl());
                            Enumeration enumeration2 = element.children();
                            while (enumeration2.hasMoreElements()) {
                                Element element5 = (Element)enumeration2.nextElement();
                                element4.addChild(element5);
                            }
                            element4.addTarget((Element)object);
                            this.processDescription(element4, true, false, false);
                        }
                        continue;
                    }
                    if (!this.isTypedPredicate(element3)) continue;
                    object3 = new Element(RDFMS_Description, new AttributeListImpl());
                    object2 = element.children();
                    while (object2.hasMoreElements()) {
                        object = (Element)object2.nextElement();
                        ((Element)object3).addChild((Element)object);
                    }
                    ((Element)object3).addTarget(element3);
                    this.processDescription((Element)object3, true, false, false);
                }
            } else if (this.isDescription(element2)) {
                this.processDescription(element2, false, bl2, bl3);
                Enumeration enumeration = element2.children();
                while (enumeration.hasMoreElements()) {
                    Element element6 = (Element)enumeration.nextElement();
                    Element element7 = new Element(RDFMS_Description, new AttributeListImpl());
                    Enumeration enumeration3 = element.children();
                    while (enumeration3.hasMoreElements()) {
                        Element element8 = (Element)enumeration3.nextElement();
                        element7.addChild(element8);
                    }
                    element7.addTarget(element6);
                    this.processDescription(element7, true, false, false);
                }
            }
            return null;
        }
        if (string5 != null) {
            if (bl5) {
                Enumeration enumeration = element.targets();
                while (enumeration.hasMoreElements()) {
                    element2 = (Element)enumeration.nextElement();
                    string6 = element2.about();
                    Element element9 = new Element(RDFMS_Description, new AttributeListImpl());
                    element9.about(string6);
                    Enumeration enumeration4 = element.children();
                    while (enumeration4.hasMoreElements()) {
                        Element element10 = (Element)enumeration4.nextElement();
                        element9.addChild(element10);
                    }
                    this.processDescription(element9, false, false, false);
                }
            }
            return null;
        }
        Enumeration enumeration = element.children();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            Element element11 = (Element)enumeration.nextElement();
            if (this.isDescription(element11)) {
                this.addError("Cannot nest a Description inside another Description");
                continue;
            }
            if (this.isListItem(element11)) {
                this.processListItem(string, element11, n2);
                ++n2;
                continue;
            }
            if (this.isContainer(element11)) {
                this.addError("Cannot nest a container (Bag/Alt/Seq) inside a Description");
                continue;
            }
            if (!this.isTypedPredicate(element11)) continue;
            String string9 = null;
            if (bl5 && bl6) {
                string9 = this.processPredicate(element11, element, element2.bagID() != null ? element2.bagID() : element2.ID(), false);
                element.ID(string9, this.source());
                bl3 = false;
            } else if (bl5) {
                string9 = this.processPredicate(element11, element, element2.bagID() != null ? element2.bagID() : element2.ID(), bl2);
                element.ID(string9, this.source());
            } else if (!bl5 && !bl) {
                if (element.ID() == null) {
                    element.ID(this.newReificationID());
                }
                if (string3 == null) {
                    string3 = string != null ? string : element.ID();
                }
                string9 = this.processPredicate(element11, element, string3, string2 != null ? true : bl2);
            } else if (!bl5 && bl) {
                if (string3 == null) {
                    if (string != null) {
                        element.ID(string, this.source());
                        string3 = string;
                    } else {
                        if (element.ID() == null) {
                            element.ID(this.newReificationID());
                        }
                        string3 = element.ID();
                    }
                } else {
                    element.ID(string3);
                }
                string9 = this.processPredicate(element11, element, string3, false);
            }
            if (string2 == null && (!this.m_bCreateBags || !bl3)) continue;
            String string10 = RDFMS;
            if (bl4 && string9 != null) {
                bl4 = false;
                if (element.bagID() == null) {
                    element.bagID(this.newReificationID());
                }
                if (element.ID() == null) {
                    element.ID(element.bagID(), this.source());
                }
                this.addTriple(this.createResource(string10, "type"), this.createResource(element.bagID()), this.createResource(string10, "Bag"));
            }
            if (string9 == null) continue;
            this.addTriple(this.createResource(string10, "_" + n), this.createResource(element.bagID()), this.createResource(string9));
            ++n;
        }
        element.done(true);
        return element.ID();
    }

    private void processListItem(String string, Element element, int n) throws SAXException, ModelException {
        Resource resource;
        String string2 = element.resource();
        Resource resource2 = resource = element.name().endsWith("li") ? this.createResource(RDFMS, "_" + n) : this.createResource(element.namespace(), element.localName());
        if (string2 != null) {
            this.addTriple(resource, this.createResource(string), this.createResource(string2));
            if (element.children().hasMoreElements()) {
                this.addError("Listitem with 'resource' attribute cannot have child nodes - see <a href=\"http://www.w3.org/TR/REC-rdf-syntax/#referencedItem\">[6.29]</a>");
            }
            element.ID(string2, this.source());
        } else {
            Enumeration enumeration = element.children();
            while (enumeration.hasMoreElements()) {
                String string3;
                Element element2 = (Element)enumeration.nextElement();
                if (element2 instanceof Data) {
                    this.addTriple(resource, this.createResource(string), this.createLiteral(((Data)element2).data()));
                    continue;
                }
                if (this.isDescription(element2)) {
                    string3 = this.processDescription(element2, false, true, false);
                    this.addTriple(resource, this.createResource(string), this.createResource(string3));
                    element.ID(string3, this.source());
                    continue;
                }
                if (this.isListItem(element2)) {
                    this.addError("Cannot nest a listitem inside another listitem");
                    continue;
                }
                if (this.isContainer(element2)) {
                    this.processContainer(element2);
                    this.addTriple(resource, this.createResource(string), this.createResource(element2.ID()));
                    continue;
                }
                if (!this.isTypedPredicate(element2)) continue;
                string3 = this.processTypedNode(element2);
                this.addTriple(resource, this.createResource(string), this.createResource(string3));
            }
        }
    }

    private String processPredicate(Element element, Element element2, String string, boolean bl) throws SAXException, ModelException {
        Object object = element.ID();
        String string2 = element.bagID();
        String string3 = element.resource();
        Element element3 = new Element(RDFMS_Description, new AttributeListImpl());
        if (this.expandAttributes(element3, element, true)) {
            if (element.children().hasMoreElements()) {
                this.addError(String.valueOf(element.name()) + " must be an empty element since it uses propAttr grammar production - see <a href=\"http://www.w3.org/TR/REC-rdf-syntax/#propertyElt\">[6.12]</a>");
                return null;
            }
            if (object != null) {
                element3.addAttribute(RDFMS_about, (String)object);
                element.addChild(new Data((String)object));
            } else if (string3 != null) {
                element3.addAttribute(RDFMS_about, string3);
            } else {
                object = this.newReificationID();
                element3.addAttribute(RDFMS_about, (String)object);
            }
            if (string2 != null) {
                element3.addAttribute(RDFMS_bagID, string2);
                element3.bagID(string2);
            }
            this.processDescription(element3, false, false, this.m_bCreateBags);
        }
        if (string3 != null && !element.children().hasMoreElements()) {
            if (element.target() == null) {
                if (bl) {
                    object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(string3), element.ID());
                    element.ID((String)object, this.source());
                } else {
                    this.addOrder(element, 0, null, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(string3));
                }
            } else if (bl) {
                object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(element.target().ID()), element.ID());
                element.ID((String)object, this.source());
            } else {
                this.addOrder(element, 0, null, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(element.target().ID()));
            }
            return element.ID();
        }
        if (string3 != null && element.target() != null) {
            object = this.processDescription(element.target(), true, false, false);
            if (bl) {
                object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object), element.ID());
                element.ID((String)object, this.source());
            } else {
                this.addOrder(element, 0, null, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object));
            }
            return object;
        }
        String string4 = this.newReificationID();
        Enumeration enumeration = element.children();
        if (!enumeration.hasMoreElements()) {
            if (bl) {
                object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(string4), element.ID());
            } else {
                this.addOrder(element, 0, null, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource(string4));
            }
        }
        Statement statement = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object object2;
            Element element4 = (Element)enumeration.nextElement();
            if (this.isDescription(element4)) {
                object2 = element4;
                object = this.processDescription((Element)object2, true, false, false);
                ((Element)object2).ID((String)object, this.source());
                if (bl) {
                    object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object), element.ID());
                    continue;
                }
                statement = this.addOrder(element, ++n, statement, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object));
                continue;
            }
            if (element4 instanceof Data) {
                object2 = ((Data)element4).data();
                boolean bl2 = ((Data)element4).isXML();
                if (bl) {
                    object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createLiteral((String)object2, bl2), element.ID());
                    element.ID((String)object, this.source());
                    continue;
                }
                statement = this.addOrder(element, ++n, statement, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createLiteral((String)object2, bl2));
                continue;
            }
            if (this.isContainer(element4)) {
                object = object2 = this.processContainer(element4);
                if (element2.target() != null) {
                    if (bl) {
                        object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(element2.target().about()), this.createResource((String)object2), element.ID());
                        element.ID((String)object, this.source());
                        continue;
                    }
                    this.addTriple(this.createResource(element.namespace(), element.localName()), this.createResource(element2.target().about()), this.createResource((String)object2));
                    continue;
                }
                if (bl) {
                    object = this.reify(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object2), element.ID());
                    element.ID((String)object, this.source());
                    continue;
                }
                this.addTriple(this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object2));
                continue;
            }
            if (!this.isTypedPredicate(element4)) continue;
            object = this.processTypedNode(element4);
            statement = this.addOrder(element, ++n, statement, this.createResource(element.namespace(), element.localName()), this.createResource(string), this.createResource((String)object));
        }
        return object;
    }

    public void processRDF(Element element) throws SAXException, ModelException {
        Enumeration enumeration = element.children();
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            if (this.isDescription(element2)) {
                this.processDescription(element2, false, this.m_bCreateBags, this.m_bCreateBags);
                continue;
            }
            if (this.isContainer(element2)) {
                this.processContainer(element2);
                continue;
            }
            if (!this.isTypedPredicate(element2)) continue;
            this.processTypedNode(element2);
        }
    }

    public String processTypedNode(Element element) throws SAXException, ModelException {
        Data data;
        Object object;
        Object object2;
        Object object3;
        String string = element.ID();
        String string2 = element.bagID();
        String string3 = element.about();
        Element element2 = element.target();
        String string4 = element.aboutEach();
        String string5 = element.aboutEachPrefix();
        if (element.resource() != null) {
            this.addError("'resource' attribute not allowed for a typedNode " + element.name() + " - see <a href=\"http://www.w3.org/TR/REC-rdf-syntax/#typedNode\">[6.13]</a>");
        }
        Enumeration enumeration = element.attributes();
        while (enumeration.hasMoreElements()) {
            object3 = (QName)enumeration.nextElement();
            object2 = element.getAttribute((QName)object3);
            object2 = ((String)object2).trim();
            if (RDFMS.equals(((QName)object3).getNamespace()) || XMLSCHEMA.equals(((QName)object3).getNamespace()) || ((String)object2).length() <= 0) continue;
            object = new Element(((QName)object3).getNamespace(), ((QName)object3).getLocalName(), new AttributeListImpl());
            ((Element)object).addAttribute(RDFMS_ID, string3 != null ? string3 : string);
            ((Element)object).addAttribute(RDFMS_bagID, string2);
            data = new Data((String)object2);
            ((Element)object).addChild(data);
            element.addChild((Element)object);
            element.removeAttribute((QName)object3);
        }
        object3 = null;
        object3 = element2 != null ? (element2.bagID() != null ? element2.bagID() : element2.ID()) : (string3 != null ? string3 : (string != null ? string : this.newReificationID()));
        element.ID((String)object3, this.source());
        object2 = element.targets();
        if (string4 != null && object2.hasMoreElements()) {
            object = new Element(RDFMS, "type", new AttributeListImpl());
            data = new Data(element.name());
            ((Element)object).addChild(data);
            element.addChild((Element)object);
        } else {
            this.addTriple(this.createResource(RDFMS, "type"), this.createResource(element.ID()), this.createResource(element.namespace(), element.localName()));
        }
        object = this.processDescription(element, false, false, false);
        return object3;
    }

    public void processXML(Element element) throws SAXException, ModelException {
        if (this.isRDFroot(element)) {
            this.processRDF(element);
        } else if (this.isDescription(element)) {
            this.processDescription(element, false, this.m_bCreateBags, this.m_bCreateBags);
        } else {
            this.processTypedNode(element);
        }
    }

    public void processingInstruction(String string, String string2) {
    }

    public void registerID(String string, Element element) throws SAXException {
        if (this.streamMode) {
            return;
        }
        if (this.m_hIDtable.get(string) != null) {
            this.addError("Node ID '" + string + "' redefined.");
        }
        this.m_hIDtable.put(string, element);
    }

    public void registerResource(Element element) {
        if (!this.streamMode) {
            this.m_vResources.addElement(element);
        }
    }

    private String reify(Resource resource, Resource resource2, RDFNode rDFNode, String string) throws SAXException, ModelException {
        String string2 = RDFMS;
        if (string == null) {
            string = this.newReificationID();
        }
        this.addTriple(resource, resource2, rDFNode);
        if (resource.equals(String.valueOf(string2) + "subject") || resource.equals(String.valueOf(string2) + "predicate") || resource.equals(String.valueOf(string2) + "object") || resource.equals(String.valueOf(string2) + "type")) {
            return null;
        }
        this.addTriple(this.createResource(string2, "predicate"), this.createResource(string), resource);
        this.addTriple(this.createResource(string2, "subject"), this.createResource(string), this.createLiteral(resource2.toString().length() == 0 ? this.source() : resource2.toString()));
        this.addTriple(this.createResource(string2, "object"), this.createResource(string), rDFNode);
        this.addTriple(this.createResource(string2, "type"), this.createResource(string), this.createResource(string2, "Statement"));
        return string;
    }

    public void resolve() throws SAXException {
        if (this.streamMode) {
            return;
        }
        int n = 0;
        while (n < this.m_vResolveQueue.size()) {
            Object object;
            Object object2;
            Object object3;
            Element element = (Element)this.m_vResolveQueue.elementAt(n);
            String string = element.about();
            if (string != null) {
                if (string.startsWith("#")) {
                    string = string.substring(1);
                }
                if ((object3 = this.lookforNode(string)) != null) {
                    element.resource(((Element)object3).ID());
                    element.addTarget((Element)object3);
                } else {
                    this.addError("Unresolved internal reference to " + string);
                }
            }
            if ((object3 = element.getAttribute(RDFMS_resource)) != null) {
                if (((String)object3).startsWith("#")) {
                    object3 = ((String)object3).substring(1);
                }
                if ((object2 = this.lookforNode((String)object3)) != null) {
                    element.resource(((Element)object2).ID());
                    element.addTarget((Element)object2);
                }
            }
            if ((object2 = element.getAttribute(RDFMS_aboutEach)) != null && (object = this.lookforNode(((String)object2).substring(1))) != null) {
                element.resource(((Element)object).ID());
                element.addTarget((Element)object);
            }
            if ((object = element.getAttribute(RDFMS_aboutEachPrefix)) != null) {
                int n2 = 0;
                while (n2 < this.m_vResources.size()) {
                    Element element2 = (Element)this.m_vResources.elementAt(n2);
                    String string2 = element2.about();
                    if (string2.startsWith((String)object)) {
                        element.addTarget(element2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.m_vResolveQueue.removeAllElements();
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.ignoreExternalEntities) {
            System.err.println("[Warning] ignoring external entity " + string2);
            return new InputSource(new CharArrayReader(new char[0]));
        }
        return null;
    }

    public void resolveLater(Element element) {
        if (!this.streamMode) {
            this.m_vResolveQueue.addElement(element);
        }
    }

    public Element root() {
        return this.m_root;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setRDFSource(InputSource inputSource) {
        this.m_RDFsource = inputSource;
    }

    public void setRobustMode(boolean bl) {
        this.robustMode = bl;
    }

    public void setSource(String string) {
        this.m_sSource = string;
        if (!(this.m_sSource == null || string.endsWith("#") || string.endsWith("/") || string.endsWith(":"))) {
            this.m_sSource = String.valueOf(this.m_sSource) + "#";
            this.m_sSourceModified = true;
        }
        if (this.m_sSource != null) {
            s_vNSdone.addElement(this.m_sSource);
        }
    }

    public void setStreamMode(boolean bl) {
        this.streamMode = bl;
    }

    public String source() {
        return this.m_sSource;
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributeList.getLength();
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                string2 = attributeList.getName(n2);
                if (string2.equals(XMLNS)) {
                    object3 = attributeList.getValue(string2);
                    if (object3 != null && ((String)object3).length() == 0 && this.source() != null) {
                        object3 = this.source();
                    }
                    hashtable.put(string2, (String)object3);
                    if (!this.hasString(s_vNStodo, (String)object3) && !this.hasString(s_vNSdone, (String)object3)) {
                        s_vNStodo.addElement(object3);
                    }
                } else if (string2.startsWith(XMLNS_COLON)) {
                    object3 = attributeList.getValue(string2);
                    if (object3 != null && ((String)object3).length() == 0 && this.source() != null) {
                        object3 = this.source();
                    }
                    string2 = string2.substring(6);
                    hashtable.put(string2, (String)object3);
                    if (!this.hasString(s_vNStodo, (String)object3) && !this.hasString(s_vNSdone, (String)object3)) {
                        s_vNStodo.addElement(object3);
                    }
                }
                ++n2;
            }
        }
        while (s_vNStodo.size() > 0) {
            String string3 = (String)s_vNStodo.elementAt(0);
            s_vNStodo.removeElementAt(0);
            s_vNSdone.addElement(string3);
            if (!this.m_bFetchSchemas) continue;
            this.fetchSchema(string3);
        }
        this.m_namespaceStack.push(hashtable);
        String string4 = null;
        string2 = null;
        object3 = null;
        int n3 = string.indexOf(58);
        String string5 = null;
        if (n3 > 0) {
            string5 = string.substring(0, n3);
            string4 = this.namespace(string5);
            string2 = string.substring(n3 + 1);
        } else {
            string4 = this.namespace(XMLNS);
            string2 = string;
        }
        boolean bl2 = false;
        switch (this.scanMode) {
            case 0: {
                if (!RDFMS.equals(string4)) break;
                if (string2.equals(_RDF)) {
                    this.scanMode = 1;
                    bl2 = true;
                    break;
                }
                if (!string2.equals(DESCRIPTION)) break;
                this.scanMode = 3;
                bl2 = true;
                break;
            }
            case 1: {
                this.scanMode = 2;
                bl2 = true;
                break;
            }
        }
        boolean bl3 = bl = this.scanMode != 0 && this.parseLiteral();
        if (this.scanMode != 0) {
            int n4 = 0;
            while (n4 < n) {
                object2 = null;
                object = attributeList.getName(n4);
                if (!((String)object).startsWith(XMLNS)) {
                    String string6 = attributeList.getValue((String)object);
                    String string7 = attributeList.getType((String)object);
                    int n5 = ((String)object).indexOf(58);
                    String string8 = null;
                    if (n5 > 0) {
                        string8 = ((String)object).substring(0, n5);
                        object2 = this.namespace(string8);
                        object = ((String)object).substring(n5 + 1);
                    }
                    if (bl) {
                        if (string8 == null) {
                            string8 = "gen" + n4;
                        }
                        attributesImpl.addAttribute(String.valueOf(string8) + ":", (String)object, null, string7, string6);
                        attributesImpl.addAttribute(XMLNS_COLON, string8, null, string7, (String)object2);
                    } else {
                        attributesImpl.addAttribute((String)object2, (String)object, null, string7, string6);
                    }
                }
                ++n4;
            }
        }
        if (bl) {
            if (string5 == null) {
                if (string4 != null) {
                    attributesImpl.addAttribute(XMLNS_COLON, "gen", null, "CDATA", string4);
                }
                object3 = new Element("gen:", string2, attributesImpl);
                ((Element)object3).prefix("gen");
            } else {
                String string9 = this.namespace(string5);
                if (string9 != null) {
                    attributesImpl.addAttribute(XMLNS_COLON, string5, null, "CDATA", string9);
                }
                object3 = new Element(String.valueOf(string5) + ":", string2, attributesImpl);
            }
        } else {
            object3 = new Element(string4, string2, attributesImpl);
        }
        if (bl2) {
            this.scanModeElement = object3;
        }
        String string10 = null;
        if (this.scanMode != 0) {
            this.checkAttributes((Element)object3);
            string10 = ((Element)object3).getAttribute(RDFMS_parseType);
            if (string10 != null && !string10.equals(RDFMS_parseType_Resource)) {
                this.m_parseTypeStack.push(string10);
                if (!this.m_elementStack.empty()) {
                    object2 = (Element)this.m_elementStack.peek();
                    ((Element)object2).addChild((Element)object3);
                }
                this.m_elementStack.push(object3);
                this.m_parseElementStack.push(object3);
                this.m_sLiteral = "";
                return;
            }
            if (bl) {
                this.makeMarkupST((Element)object3);
                this.m_elementStack.push(object3);
                return;
            }
        }
        if (!(this.m_elementStack.empty() || this.streamMode && bl2)) {
            object2 = (Element)this.m_elementStack.peek();
            ((Element)object2).addChild((Element)object3);
        }
        this.m_elementStack.push(object3);
        if (string10 != null && string10.equals(RDFMS_parseType_Resource)) {
            this.m_parseTypeStack.push(string10);
            this.m_parseElementStack.push(object3);
            this.m_sLiteral = "";
            object2 = new Element(RDFMS_Description, new AttributeListImpl());
            if (!this.m_elementStack.empty()) {
                object = (Element)this.m_elementStack.peek();
                ((Element)object).addChild((Element)object2);
            }
            this.m_elementStack.push(object2);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public void useExperimentalFeatures(boolean bl) {
        this.ENABLE_EXPERIMENTAL = bl;
    }
}

