/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.List;

public class LoadOWLDataRangeTestCase
extends AbstractJenaTestCase {
    public void testLoadFloatRestriction() throws Exception {
        OWLNamedClass oldClass = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty oldProperty = this.owlModel.createOWLDatatypeProperty("property");
        RDFSLiteral oldFirstLiteral = this.owlModel.createRDFSLiteral("1.1", this.owlModel.getXSDfloat());
        RDFSLiteral oldSecondLiteral = this.owlModel.createRDFSLiteral("2.2", this.owlModel.getXSDfloat());
        OWLDataRange oldDataRange = this.owlModel.createOWLDataRange(new RDFSLiteral[]{oldFirstLiteral, oldSecondLiteral});
        OWLAllValuesFrom oldAllValuesFrom = this.owlModel.createOWLAllValuesFrom((RDFProperty)oldProperty, oldDataRange);
        oldClass.addSuperclass(oldAllValuesFrom);
        JenaOWLModel newModel = LoadOWLDataRangeTestCase.reload(this.owlModel);
        OWLNamedClass newClass = newModel.getOWLNamedClass(oldClass.getName());
        OWLDatatypeProperty newProperty = newModel.getOWLDatatypeProperty(oldProperty.getName());
        OWLAllValuesFrom newAllValuesFrom = (OWLAllValuesFrom)newClass.getRestrictions().iterator().next();
        LoadOWLDataRangeTestCase.assertEquals((Object)newProperty, (Object)newAllValuesFrom.getOnProperty());
        OWLDataRange newDataRange = (OWLDataRange)newAllValuesFrom.getAllValuesFrom();
        LoadOWLDataRangeTestCase.assertSize(2, newDataRange.getOneOfValues());
        LoadOWLDataRangeTestCase.assertEquals((Object)new Float(1.1), newDataRange.getOneOfValues().get(0));
        LoadOWLDataRangeTestCase.assertEquals((Object)new Float(2.2), newDataRange.getOneOfValues().get(1));
    }

    public void testLoadFloatRestrictionFromFile() throws Exception {
        this.loadRemoteOntology("datatypeEnumerationFloat.owl");
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("Cls");
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)cls.getRestrictions(false).iterator().next();
        RDFResource filler = restriction.getFiller();
        LoadOWLDataRangeTestCase.assertTrue((boolean)(filler instanceof OWLDataRange));
        List values = ((OWLDataRange)filler).getOneOf().getValues();
        LoadOWLDataRangeTestCase.assertSize(2, values);
        LoadOWLDataRangeTestCase.assertContains((Object)new Float(1.1), values);
        LoadOWLDataRangeTestCase.assertContains((Object)new Float(2.2), values);
    }

    public void testLoadIntRestrictionFromFile() throws Exception {
        this.loadRemoteOntology("datatypeEnumerationInt.owl");
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("Cls");
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)cls.getRestrictions(false).iterator().next();
        RDFResource filler = restriction.getFiller();
        LoadOWLDataRangeTestCase.assertTrue((boolean)(filler instanceof OWLDataRange));
        List values = ((OWLDataRange)filler).getOneOf().getValues();
        LoadOWLDataRangeTestCase.assertSize(2, values);
        LoadOWLDataRangeTestCase.assertContains((Object)new Integer(1), values);
        LoadOWLDataRangeTestCase.assertContains((Object)new Integer(2), values);
    }

    public void testLoadStringRestrictionFromFile() throws Exception {
        this.loadRemoteOntology("datatypeEnumerationString.owl");
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("Cls");
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)cls.getRestrictions(false).iterator().next();
        RDFResource filler = restriction.getFiller();
        LoadOWLDataRangeTestCase.assertTrue((boolean)(filler instanceof OWLDataRange));
        List values = ((OWLDataRange)filler).getOneOf().getValues();
        LoadOWLDataRangeTestCase.assertSize(2, values);
        LoadOWLDataRangeTestCase.assertContains((Object)"A", values);
        LoadOWLDataRangeTestCase.assertContains((Object)"B", values);
    }

    public void testLoadOWLDataRangeValue() throws Exception {
        this.loadRemoteOntology("owlDataRangeValue.owl");
        RDFProperty property = this.owlModel.getRDFProperty("property");
        LoadOWLDataRangeTestCase.assertNotNull((Object)property);
        LoadOWLDataRangeTestCase.assertTrue((boolean)(property.getRange() instanceof OWLDataRange));
        RDFResource individual = this.owlModel.getRDFResource("Test");
        LoadOWLDataRangeTestCase.assertNotNull((Object)individual);
        LoadOWLDataRangeTestCase.assertSize(1, individual.getPropertyValues(property));
    }
}

